// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model



/**
 * Metadata about a rule. Rule metadata includes an ID, a name, a list of tags, and a short and long description. CodeGuru Reviewer uses rules to analyze code. A rule's recommendation is included in analysis results if code is detected that violates the rule.
 */
public class RuleMetadata private constructor(builder: Builder) {
    /**
     * A long description of the rule.
     */
    public val longDescription: kotlin.String? = builder.longDescription
    /**
     * The ID of the rule.
     */
    public val ruleId: kotlin.String? = builder.ruleId
    /**
     * The name of the rule.
     */
    public val ruleName: kotlin.String? = builder.ruleName
    /**
     * Tags that are associated with the rule.
     */
    public val ruleTags: List<String>? = builder.ruleTags
    /**
     * A short description of the rule.
     */
    public val shortDescription: kotlin.String? = builder.shortDescription

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codegurureviewer.model.RuleMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RuleMetadata(")
        append("longDescription=$longDescription,")
        append("ruleId=$ruleId,")
        append("ruleName=$ruleName,")
        append("ruleTags=$ruleTags,")
        append("shortDescription=$shortDescription)")
    }

    override fun hashCode(): kotlin.Int {
        var result = longDescription?.hashCode() ?: 0
        result = 31 * result + (ruleId?.hashCode() ?: 0)
        result = 31 * result + (ruleName?.hashCode() ?: 0)
        result = 31 * result + (ruleTags?.hashCode() ?: 0)
        result = 31 * result + (shortDescription?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RuleMetadata

        if (longDescription != other.longDescription) return false
        if (ruleId != other.ruleId) return false
        if (ruleName != other.ruleName) return false
        if (ruleTags != other.ruleTags) return false
        if (shortDescription != other.shortDescription) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codegurureviewer.model.RuleMetadata = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A long description of the rule.
         */
        public var longDescription: kotlin.String? = null
        /**
         * The ID of the rule.
         */
        public var ruleId: kotlin.String? = null
        /**
         * The name of the rule.
         */
        public var ruleName: kotlin.String? = null
        /**
         * Tags that are associated with the rule.
         */
        public var ruleTags: List<String>? = null
        /**
         * A short description of the rule.
         */
        public var shortDescription: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codegurureviewer.model.RuleMetadata) : this() {
            this.longDescription = x.longDescription
            this.ruleId = x.ruleId
            this.ruleName = x.ruleName
            this.ruleTags = x.ruleTags
            this.shortDescription = x.shortDescription
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codegurureviewer.model.RuleMetadata = RuleMetadata(this)
    }
}
