// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.services.codegurureviewer.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.codegurureviewer.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * This section provides documentation for the Amazon CodeGuru Reviewer API operations. CodeGuru Reviewer is a service
 * that uses program analysis and machine learning to detect potential defects that are difficult for developers to find and recommends
 * fixes in your Java and Python code.
 * By proactively detecting and providing recommendations for addressing code defects and implementing best practices, CodeGuru Reviewer
 * improves the overall quality and maintainability of your code base during the code review stage. For more information about CodeGuru Reviewer, see the
 * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/welcome.html">Amazon CodeGuru Reviewer User Guide.
 * To improve the security of your CodeGuru Reviewer API calls, you can establish a private connection between your VPC and CodeGuru Reviewer by
 * creating an interface VPC endpoint. For more information, see
 * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/vpc-interface-endpoints.html">CodeGuru Reviewer and interface
 * VPC endpoints (Amazon Web Services PrivateLink) in the Amazon CodeGuru Reviewer User Guide.
 */
interface CodeGuruReviewerClient : SdkClient {

    override val serviceName: String
        get() = "CodeGuru Reviewer"
    /**
     * CodeGuruReviewerClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.DslBuilder.() -> Unit = {}): CodeGuruReviewerClient {
            val config = Config.BuilderImpl().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
            }.apply(block).build()
            return DefaultCodeGuruReviewerClient(config)
        }

        operator fun invoke(config: Config): CodeGuruReviewerClient = DefaultCodeGuruReviewerClient(config)

        /**
         * Construct a [CodeGuruReviewerClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): CodeGuruReviewerClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return CodeGuruReviewerClient(sharedConfig)
        }
    }

    class Config private constructor(builder: BuilderImpl): AwsClientConfig, HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            @JvmStatic
            fun fluentBuilder(): FluentBuilder = BuilderImpl()

            operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Config = BuilderImpl().apply(block).build()
        }

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: AwsEndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun idempotencyTokenProvider(idempotencyTokenProvider: IdempotencyTokenProvider): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver?

            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: AwsEndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: AwsEndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun idempotencyTokenProvider(idempotencyTokenProvider: IdempotencyTokenProvider): FluentBuilder = apply { this.idempotencyTokenProvider = idempotencyTokenProvider }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
        }
    }

    /**
     * Use to associate an Amazon Web Services CodeCommit repository or a repostory managed by
     * Amazon Web Services CodeStar Connections with Amazon CodeGuru Reviewer. When you associate a
     * repository, CodeGuru Reviewer reviews source code changes in the repository's pull requests and provides
     * automatic recommendations. You can view recommendations using the CodeGuru Reviewer console. For more information, see
     * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/recommendations.html">Recommendations in
     * Amazon CodeGuru Reviewer in the Amazon CodeGuru Reviewer User Guide.
     * If you associate a CodeCommit or S3 repository, it must be in the same
     * Amazon Web Services Region and Amazon Web Services account where its CodeGuru Reviewer code reviews are configured.
     * Bitbucket and GitHub Enterprise Server repositories are managed by Amazon Web Services CodeStar
     * Connections to connect to CodeGuru Reviewer. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/getting-started-associate-repository.html">Associate a repository in
     * the Amazon CodeGuru Reviewer User Guide.
     * You cannot use the CodeGuru Reviewer SDK or the Amazon Web Services CLI to associate a GitHub repository with Amazon CodeGuru Reviewer. To associate
     * a GitHub repository, use the console. For more information, see
     * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/getting-started-with-guru.html">Getting
     * started with CodeGuru Reviewer in the CodeGuru Reviewer User Guide.
     */
    suspend fun associateRepository(input: AssociateRepositoryRequest): AssociateRepositoryResponse

    /**
     * Use to associate an Amazon Web Services CodeCommit repository or a repostory managed by
     * Amazon Web Services CodeStar Connections with Amazon CodeGuru Reviewer. When you associate a
     * repository, CodeGuru Reviewer reviews source code changes in the repository's pull requests and provides
     * automatic recommendations. You can view recommendations using the CodeGuru Reviewer console. For more information, see
     * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/recommendations.html">Recommendations in
     * Amazon CodeGuru Reviewer in the Amazon CodeGuru Reviewer User Guide.
     * If you associate a CodeCommit or S3 repository, it must be in the same
     * Amazon Web Services Region and Amazon Web Services account where its CodeGuru Reviewer code reviews are configured.
     * Bitbucket and GitHub Enterprise Server repositories are managed by Amazon Web Services CodeStar
     * Connections to connect to CodeGuru Reviewer. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/getting-started-associate-repository.html">Associate a repository in
     * the Amazon CodeGuru Reviewer User Guide.
     * You cannot use the CodeGuru Reviewer SDK or the Amazon Web Services CLI to associate a GitHub repository with Amazon CodeGuru Reviewer. To associate
     * a GitHub repository, use the console. For more information, see
     * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/getting-started-with-guru.html">Getting
     * started with CodeGuru Reviewer in the CodeGuru Reviewer User Guide.
     */
    suspend fun associateRepository(block: AssociateRepositoryRequest.DslBuilder.() -> Unit) = associateRepository(AssociateRepositoryRequest.builder().apply(block).build())

    /**
     * Use to create a code review with a <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReviewType.html">
     * CodeReviewType
     * of RepositoryAnalysis. This type of code review analyzes all code under a specified branch in an associated repository.
     * PullRequest code reviews are automatically triggered by a pull request.
     */
    suspend fun createCodeReview(input: CreateCodeReviewRequest): CreateCodeReviewResponse

    /**
     * Use to create a code review with a <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReviewType.html">
     * CodeReviewType
     * of RepositoryAnalysis. This type of code review analyzes all code under a specified branch in an associated repository.
     * PullRequest code reviews are automatically triggered by a pull request.
     */
    suspend fun createCodeReview(block: CreateCodeReviewRequest.DslBuilder.() -> Unit) = createCodeReview(CreateCodeReviewRequest.builder().apply(block).build())

    /**
     * Returns the metadata associated with the code review along with its status.
     */
    suspend fun describeCodeReview(input: DescribeCodeReviewRequest): DescribeCodeReviewResponse

    /**
     * Returns the metadata associated with the code review along with its status.
     */
    suspend fun describeCodeReview(block: DescribeCodeReviewRequest.DslBuilder.() -> Unit) = describeCodeReview(DescribeCodeReviewRequest.builder().apply(block).build())

    /**
     * Describes the customer feedback for a CodeGuru Reviewer recommendation.
     */
    suspend fun describeRecommendationFeedback(input: DescribeRecommendationFeedbackRequest): DescribeRecommendationFeedbackResponse

    /**
     * Describes the customer feedback for a CodeGuru Reviewer recommendation.
     */
    suspend fun describeRecommendationFeedback(block: DescribeRecommendationFeedbackRequest.DslBuilder.() -> Unit) = describeRecommendationFeedback(DescribeRecommendationFeedbackRequest.builder().apply(block).build())

    /**
     * Returns a <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
     * RepositoryAssociation
     * object
     * that contains information about the requested repository association.
     */
    suspend fun describeRepositoryAssociation(input: DescribeRepositoryAssociationRequest): DescribeRepositoryAssociationResponse

    /**
     * Returns a <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
     * RepositoryAssociation
     * object
     * that contains information about the requested repository association.
     */
    suspend fun describeRepositoryAssociation(block: DescribeRepositoryAssociationRequest.DslBuilder.() -> Unit) = describeRepositoryAssociation(DescribeRepositoryAssociationRequest.builder().apply(block).build())

    /**
     * Removes the association between Amazon CodeGuru Reviewer and a repository.
     */
    suspend fun disassociateRepository(input: DisassociateRepositoryRequest): DisassociateRepositoryResponse

    /**
     * Removes the association between Amazon CodeGuru Reviewer and a repository.
     */
    suspend fun disassociateRepository(block: DisassociateRepositoryRequest.DslBuilder.() -> Unit) = disassociateRepository(DisassociateRepositoryRequest.builder().apply(block).build())

    /**
     * Lists all the code reviews that the customer has created in the past 90 days.
     */
    suspend fun listCodeReviews(input: ListCodeReviewsRequest): ListCodeReviewsResponse

    /**
     * Lists all the code reviews that the customer has created in the past 90 days.
     */
    suspend fun listCodeReviews(block: ListCodeReviewsRequest.DslBuilder.() -> Unit) = listCodeReviews(ListCodeReviewsRequest.builder().apply(block).build())

    /**
     * Returns a list of
     * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RecommendationFeedbackSummary.html">
     * RecommendationFeedbackSummary
     * objects that contain customer recommendation feedback for all CodeGuru Reviewer users.
     */
    suspend fun listRecommendationFeedback(input: ListRecommendationFeedbackRequest): ListRecommendationFeedbackResponse

    /**
     * Returns a list of
     * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RecommendationFeedbackSummary.html">
     * RecommendationFeedbackSummary
     * objects that contain customer recommendation feedback for all CodeGuru Reviewer users.
     */
    suspend fun listRecommendationFeedback(block: ListRecommendationFeedbackRequest.DslBuilder.() -> Unit) = listRecommendationFeedback(ListRecommendationFeedbackRequest.builder().apply(block).build())

    /**
     * Returns the list of all recommendations for a completed code review.
     */
    suspend fun listRecommendations(input: ListRecommendationsRequest): ListRecommendationsResponse

    /**
     * Returns the list of all recommendations for a completed code review.
     */
    suspend fun listRecommendations(block: ListRecommendationsRequest.DslBuilder.() -> Unit) = listRecommendations(ListRecommendationsRequest.builder().apply(block).build())

    /**
     * Returns a list of <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html">
     * RepositoryAssociationSummary
     * objects that
     * contain summary information about a repository association. You can filter the returned list by
     * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-ProviderType">
     * ProviderType
     * ,
     * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-Name">
     * Name
     * ,
     * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-State">
     * State
     * , and
     * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-Owner">
     * Owner
     * .
     */
    suspend fun listRepositoryAssociations(input: ListRepositoryAssociationsRequest): ListRepositoryAssociationsResponse

    /**
     * Returns a list of <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html">
     * RepositoryAssociationSummary
     * objects that
     * contain summary information about a repository association. You can filter the returned list by
     * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-ProviderType">
     * ProviderType
     * ,
     * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-Name">
     * Name
     * ,
     * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-State">
     * State
     * , and
     * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-Owner">
     * Owner
     * .
     */
    suspend fun listRepositoryAssociations(block: ListRepositoryAssociationsRequest.DslBuilder.() -> Unit) = listRepositoryAssociations(ListRepositoryAssociationsRequest.builder().apply(block).build())

    /**
     * Returns the list of tags associated with an associated repository resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns the list of tags associated with an associated repository resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.DslBuilder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.builder().apply(block).build())

    /**
     * Stores customer feedback for a CodeGuru Reviewer recommendation. When this API is called again with different reactions the previous feedback is overwritten.
     */
    suspend fun putRecommendationFeedback(input: PutRecommendationFeedbackRequest): PutRecommendationFeedbackResponse

    /**
     * Stores customer feedback for a CodeGuru Reviewer recommendation. When this API is called again with different reactions the previous feedback is overwritten.
     */
    suspend fun putRecommendationFeedback(block: PutRecommendationFeedbackRequest.DslBuilder.() -> Unit) = putRecommendationFeedback(PutRecommendationFeedbackRequest.builder().apply(block).build())

    /**
     * Adds one or more tags to an associated repository.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds one or more tags to an associated repository.
     */
    suspend fun tagResource(block: TagResourceRequest.DslBuilder.() -> Unit) = tagResource(TagResourceRequest.builder().apply(block).build())

    /**
     * Removes a tag from an associated repository.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes a tag from an associated repository.
     */
    suspend fun untagResource(block: UntagResourceRequest.DslBuilder.() -> Unit) = untagResource(UntagResourceRequest.builder().apply(block).build())
}
