// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.services.codegurureviewer.model.*
import aws.sdk.kotlin.services.codegurureviewer.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "CodeGuru Reviewer"
const val ServiceApiVersion: String = "2019-09-19"
const val SdkVersion: String = "0.9.2-alpha"

internal class DefaultCodeGuruReviewerClient(override val config: CodeGuruReviewerClient.Config) : CodeGuruReviewerClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }

    /**
     * Use to associate an Amazon Web Services CodeCommit repository or a repostory managed by
     * Amazon Web Services CodeStar Connections with Amazon CodeGuru Reviewer. When you associate a
     * repository, CodeGuru Reviewer reviews source code changes in the repository's pull requests and provides
     * automatic recommendations. You can view recommendations using the CodeGuru Reviewer console. For more information, see
     * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/recommendations.html">Recommendations in
     * Amazon CodeGuru Reviewer in the Amazon CodeGuru Reviewer User Guide.
     * If you associate a CodeCommit or S3 repository, it must be in the same
     * Amazon Web Services Region and Amazon Web Services account where its CodeGuru Reviewer code reviews are configured.
     * Bitbucket and GitHub Enterprise Server repositories are managed by Amazon Web Services CodeStar
     * Connections to connect to CodeGuru Reviewer. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/getting-started-associate-repository.html">Associate a repository in
     * the Amazon CodeGuru Reviewer User Guide.
     * You cannot use the CodeGuru Reviewer SDK or the Amazon Web Services CLI to associate a GitHub repository with Amazon CodeGuru Reviewer. To associate
     * a GitHub repository, use the console. For more information, see
     * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/getting-started-with-guru.html">Getting
     * started with CodeGuru Reviewer in the CodeGuru Reviewer User Guide.
     */
    override suspend fun associateRepository(input: AssociateRepositoryRequest): AssociateRepositoryResponse {
        val op = SdkHttpOperation.build<AssociateRepositoryRequest, AssociateRepositoryResponse> {
            serializer = AssociateRepositoryOperationSerializer()
            deserializer = AssociateRepositoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateRepository"
            }
        }
        registerAssociateRepositoryMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Use to create a code review with a <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReviewType.html">
     * CodeReviewType
     * of RepositoryAnalysis. This type of code review analyzes all code under a specified branch in an associated repository.
     * PullRequest code reviews are automatically triggered by a pull request.
     */
    override suspend fun createCodeReview(input: CreateCodeReviewRequest): CreateCodeReviewResponse {
        val op = SdkHttpOperation.build<CreateCodeReviewRequest, CreateCodeReviewResponse> {
            serializer = CreateCodeReviewOperationSerializer()
            deserializer = CreateCodeReviewOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCodeReview"
            }
        }
        registerCreateCodeReviewMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the metadata associated with the code review along with its status.
     */
    override suspend fun describeCodeReview(input: DescribeCodeReviewRequest): DescribeCodeReviewResponse {
        val op = SdkHttpOperation.build<DescribeCodeReviewRequest, DescribeCodeReviewResponse> {
            serializer = DescribeCodeReviewOperationSerializer()
            deserializer = DescribeCodeReviewOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCodeReview"
            }
        }
        registerDescribeCodeReviewMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the customer feedback for a CodeGuru Reviewer recommendation.
     */
    override suspend fun describeRecommendationFeedback(input: DescribeRecommendationFeedbackRequest): DescribeRecommendationFeedbackResponse {
        val op = SdkHttpOperation.build<DescribeRecommendationFeedbackRequest, DescribeRecommendationFeedbackResponse> {
            serializer = DescribeRecommendationFeedbackOperationSerializer()
            deserializer = DescribeRecommendationFeedbackOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeRecommendationFeedback"
            }
        }
        registerDescribeRecommendationFeedbackMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
     * RepositoryAssociation
     * object
     * that contains information about the requested repository association.
     */
    override suspend fun describeRepositoryAssociation(input: DescribeRepositoryAssociationRequest): DescribeRepositoryAssociationResponse {
        val op = SdkHttpOperation.build<DescribeRepositoryAssociationRequest, DescribeRepositoryAssociationResponse> {
            serializer = DescribeRepositoryAssociationOperationSerializer()
            deserializer = DescribeRepositoryAssociationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeRepositoryAssociation"
            }
        }
        registerDescribeRepositoryAssociationMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Removes the association between Amazon CodeGuru Reviewer and a repository.
     */
    override suspend fun disassociateRepository(input: DisassociateRepositoryRequest): DisassociateRepositoryResponse {
        val op = SdkHttpOperation.build<DisassociateRepositoryRequest, DisassociateRepositoryResponse> {
            serializer = DisassociateRepositoryOperationSerializer()
            deserializer = DisassociateRepositoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateRepository"
            }
        }
        registerDisassociateRepositoryMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the code reviews that the customer has created in the past 90 days.
     */
    override suspend fun listCodeReviews(input: ListCodeReviewsRequest): ListCodeReviewsResponse {
        val op = SdkHttpOperation.build<ListCodeReviewsRequest, ListCodeReviewsResponse> {
            serializer = ListCodeReviewsOperationSerializer()
            deserializer = ListCodeReviewsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCodeReviews"
            }
        }
        registerListCodeReviewsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of
     * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RecommendationFeedbackSummary.html">
     * RecommendationFeedbackSummary
     * objects that contain customer recommendation feedback for all CodeGuru Reviewer users.
     */
    override suspend fun listRecommendationFeedback(input: ListRecommendationFeedbackRequest): ListRecommendationFeedbackResponse {
        val op = SdkHttpOperation.build<ListRecommendationFeedbackRequest, ListRecommendationFeedbackResponse> {
            serializer = ListRecommendationFeedbackOperationSerializer()
            deserializer = ListRecommendationFeedbackOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListRecommendationFeedback"
            }
        }
        registerListRecommendationFeedbackMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the list of all recommendations for a completed code review.
     */
    override suspend fun listRecommendations(input: ListRecommendationsRequest): ListRecommendationsResponse {
        val op = SdkHttpOperation.build<ListRecommendationsRequest, ListRecommendationsResponse> {
            serializer = ListRecommendationsOperationSerializer()
            deserializer = ListRecommendationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListRecommendations"
            }
        }
        registerListRecommendationsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html">
     * RepositoryAssociationSummary
     * objects that
     * contain summary information about a repository association. You can filter the returned list by
     * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-ProviderType">
     * ProviderType
     * ,
     * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-Name">
     * Name
     * ,
     * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-State">
     * State
     * , and
     * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-Owner">
     * Owner
     * .
     */
    override suspend fun listRepositoryAssociations(input: ListRepositoryAssociationsRequest): ListRepositoryAssociationsResponse {
        val op = SdkHttpOperation.build<ListRepositoryAssociationsRequest, ListRepositoryAssociationsResponse> {
            serializer = ListRepositoryAssociationsOperationSerializer()
            deserializer = ListRepositoryAssociationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListRepositoryAssociations"
            }
        }
        registerListRepositoryAssociationsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the list of tags associated with an associated repository resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        registerListTagsForResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Stores customer feedback for a CodeGuru Reviewer recommendation. When this API is called again with different reactions the previous feedback is overwritten.
     */
    override suspend fun putRecommendationFeedback(input: PutRecommendationFeedbackRequest): PutRecommendationFeedbackResponse {
        val op = SdkHttpOperation.build<PutRecommendationFeedbackRequest, PutRecommendationFeedbackResponse> {
            serializer = PutRecommendationFeedbackOperationSerializer()
            deserializer = PutRecommendationFeedbackOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutRecommendationFeedback"
            }
        }
        registerPutRecommendationFeedbackMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Adds one or more tags to an associated repository.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        registerTagResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Removes a tag from an associated repository.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        registerUntagResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
