// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model



class AssociateRepositoryRequest private constructor(builder: BuilderImpl) {
    /**
     * Amazon CodeGuru Reviewer uses this value to prevent the accidental creation of duplicate repository
     * associations if there are failures and retries.
     */
    val clientRequestToken: String? = builder.clientRequestToken
    /**
     * A KMSKeyDetails object that contains:
     * The encryption option for this repository association. It is either owned by Amazon Web Services
     * Key Management Service (KMS) (AWS_OWNED_CMK) or customer managed (CUSTOMER_MANAGED_CMK).
     * The ID of the Amazon Web Services KMS key that
     * is associated with this respository association.
     */
    val kmsKeyDetails: KmsKeyDetails? = builder.kmsKeyDetails
    /**
     * The repository to associate.
     */
    val repository: Repository? = builder.repository
    /**
     * An array of key-value pairs used to tag an associated repository. A tag is a custom attribute label with two parts:
     * A tag key (for example, CostCenter,
     * Environment, Project, or Secret). Tag
     * keys are case sensitive.
     * An optional field known as a tag value (for example,
     * 111122223333, Production, or a team name).
     * Omitting the tag value is the same as using an empty string. Like tag keys, tag
     * values are case sensitive.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AssociateRepositoryRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AssociateRepositoryRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("kmsKeyDetails=$kmsKeyDetails,")
        append("repository=$repository,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (kmsKeyDetails?.hashCode() ?: 0)
        result = 31 * result + (repository?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AssociateRepositoryRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (kmsKeyDetails != other.kmsKeyDetails) return false
        if (repository != other.repository) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AssociateRepositoryRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AssociateRepositoryRequest
        /**
         * Amazon CodeGuru Reviewer uses this value to prevent the accidental creation of duplicate repository
         * associations if there are failures and retries.
         */
        fun clientRequestToken(clientRequestToken: String): FluentBuilder
        /**
         * A KMSKeyDetails object that contains:
         * The encryption option for this repository association. It is either owned by Amazon Web Services
         * Key Management Service (KMS) (AWS_OWNED_CMK) or customer managed (CUSTOMER_MANAGED_CMK).
         * The ID of the Amazon Web Services KMS key that
         * is associated with this respository association.
         */
        fun kmsKeyDetails(kmsKeyDetails: KmsKeyDetails): FluentBuilder
        /**
         * The repository to associate.
         */
        fun repository(repository: Repository): FluentBuilder
        /**
         * An array of key-value pairs used to tag an associated repository. A tag is a custom attribute label with two parts:
         * A tag key (for example, CostCenter,
         * Environment, Project, or Secret). Tag
         * keys are case sensitive.
         * An optional field known as a tag value (for example,
         * 111122223333, Production, or a team name).
         * Omitting the tag value is the same as using an empty string. Like tag keys, tag
         * values are case sensitive.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Amazon CodeGuru Reviewer uses this value to prevent the accidental creation of duplicate repository
         * associations if there are failures and retries.
         */
        var clientRequestToken: String?
        /**
         * A KMSKeyDetails object that contains:
         * The encryption option for this repository association. It is either owned by Amazon Web Services
         * Key Management Service (KMS) (AWS_OWNED_CMK) or customer managed (CUSTOMER_MANAGED_CMK).
         * The ID of the Amazon Web Services KMS key that
         * is associated with this respository association.
         */
        var kmsKeyDetails: KmsKeyDetails?
        /**
         * The repository to associate.
         */
        var repository: Repository?
        /**
         * An array of key-value pairs used to tag an associated repository. A tag is a custom attribute label with two parts:
         * A tag key (for example, CostCenter,
         * Environment, Project, or Secret). Tag
         * keys are case sensitive.
         * An optional field known as a tag value (for example,
         * 111122223333, Production, or a team name).
         * Omitting the tag value is the same as using an empty string. Like tag keys, tag
         * values are case sensitive.
         */
        var tags: Map<String, String>?

        fun build(): AssociateRepositoryRequest
        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.KmsKeyDetails] inside the given [block]
         */
        fun kmsKeyDetails(block: KmsKeyDetails.DslBuilder.() -> kotlin.Unit) {
            this.kmsKeyDetails = KmsKeyDetails.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.Repository] inside the given [block]
         */
        fun repository(block: Repository.DslBuilder.() -> kotlin.Unit) {
            this.repository = Repository.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientRequestToken: String? = null
        override var kmsKeyDetails: KmsKeyDetails? = null
        override var repository: Repository? = null
        override var tags: Map<String, String>? = null

        constructor(x: AssociateRepositoryRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.kmsKeyDetails = x.kmsKeyDetails
            this.repository = x.repository
            this.tags = x.tags
        }

        override fun build(): AssociateRepositoryRequest = AssociateRepositoryRequest(this)
        override fun clientRequestToken(clientRequestToken: String): FluentBuilder = apply { this.clientRequestToken = clientRequestToken }
        override fun kmsKeyDetails(kmsKeyDetails: KmsKeyDetails): FluentBuilder = apply { this.kmsKeyDetails = kmsKeyDetails }
        override fun repository(repository: Repository): FluentBuilder = apply { this.repository = repository }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
