// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model



/**
 * Code artifacts are source code artifacts and build artifacts used in a repository analysis or a pull request review.
 * Source code artifacts are source code files in a Git repository that are
 * compressed into a .zip file.
 * Build artifacts are .jar or .class files that are compressed in a .zip file.
 */
class CodeArtifacts private constructor(builder: BuilderImpl) {
    /**
     * The S3 object key for a build artifacts .zip file that
     * contains .jar or .class files. This is required for a code review with security analysis. For more
     * information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/code-review-security.html">Create code reviews with security
     * analysis in the Amazon CodeGuru Reviewer User Guide.
     */
    val buildArtifactsObjectKey: String? = builder.buildArtifactsObjectKey
    /**
     * The S3 object key for a source code .zip file. This is required for all code reviews.
     */
    val sourceCodeArtifactsObjectKey: String? = builder.sourceCodeArtifactsObjectKey

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CodeArtifacts = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CodeArtifacts(")
        append("buildArtifactsObjectKey=$buildArtifactsObjectKey,")
        append("sourceCodeArtifactsObjectKey=$sourceCodeArtifactsObjectKey)")
    }

    override fun hashCode(): kotlin.Int {
        var result = buildArtifactsObjectKey?.hashCode() ?: 0
        result = 31 * result + (sourceCodeArtifactsObjectKey?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CodeArtifacts

        if (buildArtifactsObjectKey != other.buildArtifactsObjectKey) return false
        if (sourceCodeArtifactsObjectKey != other.sourceCodeArtifactsObjectKey) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CodeArtifacts = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CodeArtifacts
        /**
         * The S3 object key for a build artifacts .zip file that
         * contains .jar or .class files. This is required for a code review with security analysis. For more
         * information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/code-review-security.html">Create code reviews with security
         * analysis in the Amazon CodeGuru Reviewer User Guide.
         */
        fun buildArtifactsObjectKey(buildArtifactsObjectKey: String): FluentBuilder
        /**
         * The S3 object key for a source code .zip file. This is required for all code reviews.
         */
        fun sourceCodeArtifactsObjectKey(sourceCodeArtifactsObjectKey: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The S3 object key for a build artifacts .zip file that
         * contains .jar or .class files. This is required for a code review with security analysis. For more
         * information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/code-review-security.html">Create code reviews with security
         * analysis in the Amazon CodeGuru Reviewer User Guide.
         */
        var buildArtifactsObjectKey: String?
        /**
         * The S3 object key for a source code .zip file. This is required for all code reviews.
         */
        var sourceCodeArtifactsObjectKey: String?

        fun build(): CodeArtifacts
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var buildArtifactsObjectKey: String? = null
        override var sourceCodeArtifactsObjectKey: String? = null

        constructor(x: CodeArtifacts) : this() {
            this.buildArtifactsObjectKey = x.buildArtifactsObjectKey
            this.sourceCodeArtifactsObjectKey = x.sourceCodeArtifactsObjectKey
        }

        override fun build(): CodeArtifacts = CodeArtifacts(this)
        override fun buildArtifactsObjectKey(buildArtifactsObjectKey: String): FluentBuilder = apply { this.buildArtifactsObjectKey = buildArtifactsObjectKey }
        override fun sourceCodeArtifactsObjectKey(sourceCodeArtifactsObjectKey: String): FluentBuilder = apply { this.sourceCodeArtifactsObjectKey = sourceCodeArtifactsObjectKey }
    }
}
