// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model



/**
 * Information about an Amazon Web Services CodeCommit repository. The CodeCommit repository must be in the same
 * Amazon Web Services Region and Amazon Web Services account where its CodeGuru Reviewer code reviews are configured.
 */
class CodeCommitRepository private constructor(builder: BuilderImpl) {
    /**
     * The name of the Amazon Web Services CodeCommit repository. For more information, see
     * <a href="https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetRepository.html#CodeCommit-GetRepository-request-repositoryName">repositoryName
     * in the Amazon Web Services CodeCommit API Reference.
     */
    val name: String? = builder.name

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CodeCommitRepository = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CodeCommitRepository(")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CodeCommitRepository

        if (name != other.name) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CodeCommitRepository = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CodeCommitRepository
        /**
         * The name of the Amazon Web Services CodeCommit repository. For more information, see
         * <a href="https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetRepository.html#CodeCommit-GetRepository-request-repositoryName">repositoryName
         * in the Amazon Web Services CodeCommit API Reference.
         */
        fun name(name: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the Amazon Web Services CodeCommit repository. For more information, see
         * <a href="https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetRepository.html#CodeCommit-GetRepository-request-repositoryName">repositoryName
         * in the Amazon Web Services CodeCommit API Reference.
         */
        var name: String?

        fun build(): CodeCommitRepository
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var name: String? = null

        constructor(x: CodeCommitRepository) : this() {
            this.name = x.name
        }

        override fun build(): CodeCommitRepository = CodeCommitRepository(this)
        override fun name(name: String): FluentBuilder = apply { this.name = name }
    }
}
