// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a code review. A code review belongs to the associated repository that contains the reviewed code.
 */
class CodeReview private constructor(builder: BuilderImpl) {
    /**
     * They types of analysis performed during a repository analysis or a pull request review. You can specify either
     * Security, CodeQuality, or both.
     */
    val analysisTypes: List<AnalysisType>? = builder.analysisTypes
    /**
     * The Amazon Resource Name (ARN) of the
     * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
     * RepositoryAssociation
     * that contains
     * the reviewed source code. You can retrieve associated repository ARNs by calling
     * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
     * ListRepositoryAssociations
     * .
     */
    val associationArn: String? = builder.associationArn
    /**
     * The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
     * CodeReview
     * object.
     */
    val codeReviewArn: String? = builder.codeReviewArn
    /**
     * The time, in milliseconds since the epoch, when the code review was created.
     */
    val createdTimeStamp: Instant? = builder.createdTimeStamp
    /**
     * The time, in milliseconds since the epoch, when the code review was last updated.
     */
    val lastUpdatedTimeStamp: Instant? = builder.lastUpdatedTimeStamp
    /**
     * The statistics from the code review.
     */
    val metrics: Metrics? = builder.metrics
    /**
     * The name of the code review.
     */
    val name: String? = builder.name
    /**
     * The owner of the repository. For an Amazon Web Services CodeCommit repository, this is the Amazon Web Services account ID of the
     * account that owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository, this is the username for the account that owns the repository.
     * For an S3 repository, it can be the username or Amazon Web Services account ID.
     */
    val owner: String? = builder.owner
    /**
     * The type of repository that contains the reviewed code (for example, GitHub or Bitbucket).
     */
    val providerType: ProviderType? = builder.providerType
    /**
     * The pull request ID for the code review.
     */
    val pullRequestId: String? = builder.pullRequestId
    /**
     * The name of the repository.
     */
    val repositoryName: String? = builder.repositoryName
    /**
     * The type of the source code for the code review.
     */
    val sourceCodeType: SourceCodeType? = builder.sourceCodeType
    /**
     * The valid code review states are:
     * Completed: The code review is complete.
     * Pending: The code review started and has not completed or failed.
     * Failed: The code review failed.
     * Deleting: The code review is being deleted.
     */
    val state: JobState? = builder.state
    /**
     * The reason for the state of the code review.
     */
    val stateReason: String? = builder.stateReason
    /**
     * The type of code review.
     */
    val type: Type? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CodeReview = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CodeReview(")
        append("analysisTypes=$analysisTypes,")
        append("associationArn=$associationArn,")
        append("codeReviewArn=$codeReviewArn,")
        append("createdTimeStamp=$createdTimeStamp,")
        append("lastUpdatedTimeStamp=$lastUpdatedTimeStamp,")
        append("metrics=$metrics,")
        append("name=$name,")
        append("owner=$owner,")
        append("providerType=$providerType,")
        append("pullRequestId=$pullRequestId,")
        append("repositoryName=$repositoryName,")
        append("sourceCodeType=$sourceCodeType,")
        append("state=$state,")
        append("stateReason=$stateReason,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = analysisTypes?.hashCode() ?: 0
        result = 31 * result + (associationArn?.hashCode() ?: 0)
        result = 31 * result + (codeReviewArn?.hashCode() ?: 0)
        result = 31 * result + (createdTimeStamp?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTimeStamp?.hashCode() ?: 0)
        result = 31 * result + (metrics?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (providerType?.hashCode() ?: 0)
        result = 31 * result + (pullRequestId?.hashCode() ?: 0)
        result = 31 * result + (repositoryName?.hashCode() ?: 0)
        result = 31 * result + (sourceCodeType?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateReason?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CodeReview

        if (analysisTypes != other.analysisTypes) return false
        if (associationArn != other.associationArn) return false
        if (codeReviewArn != other.codeReviewArn) return false
        if (createdTimeStamp != other.createdTimeStamp) return false
        if (lastUpdatedTimeStamp != other.lastUpdatedTimeStamp) return false
        if (metrics != other.metrics) return false
        if (name != other.name) return false
        if (owner != other.owner) return false
        if (providerType != other.providerType) return false
        if (pullRequestId != other.pullRequestId) return false
        if (repositoryName != other.repositoryName) return false
        if (sourceCodeType != other.sourceCodeType) return false
        if (state != other.state) return false
        if (stateReason != other.stateReason) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CodeReview = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CodeReview
        /**
         * They types of analysis performed during a repository analysis or a pull request review. You can specify either
         * Security, CodeQuality, or both.
         */
        fun analysisTypes(analysisTypes: List<AnalysisType>): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the
         * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
         * RepositoryAssociation
         * that contains
         * the reviewed source code. You can retrieve associated repository ARNs by calling
         * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
         * ListRepositoryAssociations
         * .
         */
        fun associationArn(associationArn: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
         * CodeReview
         * object.
         */
        fun codeReviewArn(codeReviewArn: String): FluentBuilder
        /**
         * The time, in milliseconds since the epoch, when the code review was created.
         */
        fun createdTimeStamp(createdTimeStamp: Instant): FluentBuilder
        /**
         * The time, in milliseconds since the epoch, when the code review was last updated.
         */
        fun lastUpdatedTimeStamp(lastUpdatedTimeStamp: Instant): FluentBuilder
        /**
         * The statistics from the code review.
         */
        fun metrics(metrics: Metrics): FluentBuilder
        /**
         * The name of the code review.
         */
        fun name(name: String): FluentBuilder
        /**
         * The owner of the repository. For an Amazon Web Services CodeCommit repository, this is the Amazon Web Services account ID of the
         * account that owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository, this is the username for the account that owns the repository.
         * For an S3 repository, it can be the username or Amazon Web Services account ID.
         */
        fun owner(owner: String): FluentBuilder
        /**
         * The type of repository that contains the reviewed code (for example, GitHub or Bitbucket).
         */
        fun providerType(providerType: ProviderType): FluentBuilder
        /**
         * The pull request ID for the code review.
         */
        fun pullRequestId(pullRequestId: String): FluentBuilder
        /**
         * The name of the repository.
         */
        fun repositoryName(repositoryName: String): FluentBuilder
        /**
         * The type of the source code for the code review.
         */
        fun sourceCodeType(sourceCodeType: SourceCodeType): FluentBuilder
        /**
         * The valid code review states are:
         * Completed: The code review is complete.
         * Pending: The code review started and has not completed or failed.
         * Failed: The code review failed.
         * Deleting: The code review is being deleted.
         */
        fun state(state: JobState): FluentBuilder
        /**
         * The reason for the state of the code review.
         */
        fun stateReason(stateReason: String): FluentBuilder
        /**
         * The type of code review.
         */
        fun type(type: Type): FluentBuilder
    }

    interface DslBuilder {
        /**
         * They types of analysis performed during a repository analysis or a pull request review. You can specify either
         * Security, CodeQuality, or both.
         */
        var analysisTypes: List<AnalysisType>?
        /**
         * The Amazon Resource Name (ARN) of the
         * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
         * RepositoryAssociation
         * that contains
         * the reviewed source code. You can retrieve associated repository ARNs by calling
         * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
         * ListRepositoryAssociations
         * .
         */
        var associationArn: String?
        /**
         * The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
         * CodeReview
         * object.
         */
        var codeReviewArn: String?
        /**
         * The time, in milliseconds since the epoch, when the code review was created.
         */
        var createdTimeStamp: Instant?
        /**
         * The time, in milliseconds since the epoch, when the code review was last updated.
         */
        var lastUpdatedTimeStamp: Instant?
        /**
         * The statistics from the code review.
         */
        var metrics: Metrics?
        /**
         * The name of the code review.
         */
        var name: String?
        /**
         * The owner of the repository. For an Amazon Web Services CodeCommit repository, this is the Amazon Web Services account ID of the
         * account that owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository, this is the username for the account that owns the repository.
         * For an S3 repository, it can be the username or Amazon Web Services account ID.
         */
        var owner: String?
        /**
         * The type of repository that contains the reviewed code (for example, GitHub or Bitbucket).
         */
        var providerType: ProviderType?
        /**
         * The pull request ID for the code review.
         */
        var pullRequestId: String?
        /**
         * The name of the repository.
         */
        var repositoryName: String?
        /**
         * The type of the source code for the code review.
         */
        var sourceCodeType: SourceCodeType?
        /**
         * The valid code review states are:
         * Completed: The code review is complete.
         * Pending: The code review started and has not completed or failed.
         * Failed: The code review failed.
         * Deleting: The code review is being deleted.
         */
        var state: JobState?
        /**
         * The reason for the state of the code review.
         */
        var stateReason: String?
        /**
         * The type of code review.
         */
        var type: Type?

        fun build(): CodeReview
        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.Metrics] inside the given [block]
         */
        fun metrics(block: Metrics.DslBuilder.() -> kotlin.Unit) {
            this.metrics = Metrics.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.SourceCodeType] inside the given [block]
         */
        fun sourceCodeType(block: SourceCodeType.DslBuilder.() -> kotlin.Unit) {
            this.sourceCodeType = SourceCodeType.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var analysisTypes: List<AnalysisType>? = null
        override var associationArn: String? = null
        override var codeReviewArn: String? = null
        override var createdTimeStamp: Instant? = null
        override var lastUpdatedTimeStamp: Instant? = null
        override var metrics: Metrics? = null
        override var name: String? = null
        override var owner: String? = null
        override var providerType: ProviderType? = null
        override var pullRequestId: String? = null
        override var repositoryName: String? = null
        override var sourceCodeType: SourceCodeType? = null
        override var state: JobState? = null
        override var stateReason: String? = null
        override var type: Type? = null

        constructor(x: CodeReview) : this() {
            this.analysisTypes = x.analysisTypes
            this.associationArn = x.associationArn
            this.codeReviewArn = x.codeReviewArn
            this.createdTimeStamp = x.createdTimeStamp
            this.lastUpdatedTimeStamp = x.lastUpdatedTimeStamp
            this.metrics = x.metrics
            this.name = x.name
            this.owner = x.owner
            this.providerType = x.providerType
            this.pullRequestId = x.pullRequestId
            this.repositoryName = x.repositoryName
            this.sourceCodeType = x.sourceCodeType
            this.state = x.state
            this.stateReason = x.stateReason
            this.type = x.type
        }

        override fun build(): CodeReview = CodeReview(this)
        override fun analysisTypes(analysisTypes: List<AnalysisType>): FluentBuilder = apply { this.analysisTypes = analysisTypes }
        override fun associationArn(associationArn: String): FluentBuilder = apply { this.associationArn = associationArn }
        override fun codeReviewArn(codeReviewArn: String): FluentBuilder = apply { this.codeReviewArn = codeReviewArn }
        override fun createdTimeStamp(createdTimeStamp: Instant): FluentBuilder = apply { this.createdTimeStamp = createdTimeStamp }
        override fun lastUpdatedTimeStamp(lastUpdatedTimeStamp: Instant): FluentBuilder = apply { this.lastUpdatedTimeStamp = lastUpdatedTimeStamp }
        override fun metrics(metrics: Metrics): FluentBuilder = apply { this.metrics = metrics }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun owner(owner: String): FluentBuilder = apply { this.owner = owner }
        override fun providerType(providerType: ProviderType): FluentBuilder = apply { this.providerType = providerType }
        override fun pullRequestId(pullRequestId: String): FluentBuilder = apply { this.pullRequestId = pullRequestId }
        override fun repositoryName(repositoryName: String): FluentBuilder = apply { this.repositoryName = repositoryName }
        override fun sourceCodeType(sourceCodeType: SourceCodeType): FluentBuilder = apply { this.sourceCodeType = sourceCodeType }
        override fun state(state: JobState): FluentBuilder = apply { this.state = state }
        override fun stateReason(stateReason: String): FluentBuilder = apply { this.stateReason = stateReason }
        override fun type(type: Type): FluentBuilder = apply { this.type = type }
    }
}
