// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about the summary of the code review.
 */
class CodeReviewSummary private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
     * CodeReview
     * object.
     */
    val codeReviewArn: String? = builder.codeReviewArn
    /**
     * The time, in milliseconds since the epoch, when the code review was created.
     */
    val createdTimeStamp: Instant? = builder.createdTimeStamp
    /**
     * The time, in milliseconds since the epoch, when the code review was last updated.
     */
    val lastUpdatedTimeStamp: Instant? = builder.lastUpdatedTimeStamp
    /**
     * The statistics from the code review.
     */
    val metricsSummary: MetricsSummary? = builder.metricsSummary
    /**
     * The name of the code review.
     */
    val name: String? = builder.name
    /**
     * The owner of the repository. For an Amazon Web Services CodeCommit repository, this is the Amazon Web Services account ID of the
     * account that owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository, this is the username for the account that owns the repository.
     * For an S3 repository, it can be the username or Amazon Web Services account ID.
     */
    val owner: String? = builder.owner
    /**
     * The provider type of the repository association.
     */
    val providerType: ProviderType? = builder.providerType
    /**
     * The pull request ID for the code review.
     */
    val pullRequestId: String? = builder.pullRequestId
    /**
     * The name of the repository.
     */
    val repositoryName: String? = builder.repositoryName
    /**
     * Specifies the source code that is analyzed in a code review.
     */
    val sourceCodeType: SourceCodeType? = builder.sourceCodeType
    /**
     * The state of the code review.
     * The valid code review states are:
     * Completed: The code review is complete.
     * Pending: The code review started and has not completed or failed.
     * Failed: The code review failed.
     * Deleting: The code review is being deleted.
     */
    val state: JobState? = builder.state
    /**
     * The type of the code review.
     */
    val type: Type? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CodeReviewSummary = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CodeReviewSummary(")
        append("codeReviewArn=$codeReviewArn,")
        append("createdTimeStamp=$createdTimeStamp,")
        append("lastUpdatedTimeStamp=$lastUpdatedTimeStamp,")
        append("metricsSummary=$metricsSummary,")
        append("name=$name,")
        append("owner=$owner,")
        append("providerType=$providerType,")
        append("pullRequestId=$pullRequestId,")
        append("repositoryName=$repositoryName,")
        append("sourceCodeType=$sourceCodeType,")
        append("state=$state,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = codeReviewArn?.hashCode() ?: 0
        result = 31 * result + (createdTimeStamp?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTimeStamp?.hashCode() ?: 0)
        result = 31 * result + (metricsSummary?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (providerType?.hashCode() ?: 0)
        result = 31 * result + (pullRequestId?.hashCode() ?: 0)
        result = 31 * result + (repositoryName?.hashCode() ?: 0)
        result = 31 * result + (sourceCodeType?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CodeReviewSummary

        if (codeReviewArn != other.codeReviewArn) return false
        if (createdTimeStamp != other.createdTimeStamp) return false
        if (lastUpdatedTimeStamp != other.lastUpdatedTimeStamp) return false
        if (metricsSummary != other.metricsSummary) return false
        if (name != other.name) return false
        if (owner != other.owner) return false
        if (providerType != other.providerType) return false
        if (pullRequestId != other.pullRequestId) return false
        if (repositoryName != other.repositoryName) return false
        if (sourceCodeType != other.sourceCodeType) return false
        if (state != other.state) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CodeReviewSummary = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CodeReviewSummary
        /**
         * The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
         * CodeReview
         * object.
         */
        fun codeReviewArn(codeReviewArn: String): FluentBuilder
        /**
         * The time, in milliseconds since the epoch, when the code review was created.
         */
        fun createdTimeStamp(createdTimeStamp: Instant): FluentBuilder
        /**
         * The time, in milliseconds since the epoch, when the code review was last updated.
         */
        fun lastUpdatedTimeStamp(lastUpdatedTimeStamp: Instant): FluentBuilder
        /**
         * The statistics from the code review.
         */
        fun metricsSummary(metricsSummary: MetricsSummary): FluentBuilder
        /**
         * The name of the code review.
         */
        fun name(name: String): FluentBuilder
        /**
         * The owner of the repository. For an Amazon Web Services CodeCommit repository, this is the Amazon Web Services account ID of the
         * account that owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository, this is the username for the account that owns the repository.
         * For an S3 repository, it can be the username or Amazon Web Services account ID.
         */
        fun owner(owner: String): FluentBuilder
        /**
         * The provider type of the repository association.
         */
        fun providerType(providerType: ProviderType): FluentBuilder
        /**
         * The pull request ID for the code review.
         */
        fun pullRequestId(pullRequestId: String): FluentBuilder
        /**
         * The name of the repository.
         */
        fun repositoryName(repositoryName: String): FluentBuilder
        /**
         * Specifies the source code that is analyzed in a code review.
         */
        fun sourceCodeType(sourceCodeType: SourceCodeType): FluentBuilder
        /**
         * The state of the code review.
         * The valid code review states are:
         * Completed: The code review is complete.
         * Pending: The code review started and has not completed or failed.
         * Failed: The code review failed.
         * Deleting: The code review is being deleted.
         */
        fun state(state: JobState): FluentBuilder
        /**
         * The type of the code review.
         */
        fun type(type: Type): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
         * CodeReview
         * object.
         */
        var codeReviewArn: String?
        /**
         * The time, in milliseconds since the epoch, when the code review was created.
         */
        var createdTimeStamp: Instant?
        /**
         * The time, in milliseconds since the epoch, when the code review was last updated.
         */
        var lastUpdatedTimeStamp: Instant?
        /**
         * The statistics from the code review.
         */
        var metricsSummary: MetricsSummary?
        /**
         * The name of the code review.
         */
        var name: String?
        /**
         * The owner of the repository. For an Amazon Web Services CodeCommit repository, this is the Amazon Web Services account ID of the
         * account that owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository, this is the username for the account that owns the repository.
         * For an S3 repository, it can be the username or Amazon Web Services account ID.
         */
        var owner: String?
        /**
         * The provider type of the repository association.
         */
        var providerType: ProviderType?
        /**
         * The pull request ID for the code review.
         */
        var pullRequestId: String?
        /**
         * The name of the repository.
         */
        var repositoryName: String?
        /**
         * Specifies the source code that is analyzed in a code review.
         */
        var sourceCodeType: SourceCodeType?
        /**
         * The state of the code review.
         * The valid code review states are:
         * Completed: The code review is complete.
         * Pending: The code review started and has not completed or failed.
         * Failed: The code review failed.
         * Deleting: The code review is being deleted.
         */
        var state: JobState?
        /**
         * The type of the code review.
         */
        var type: Type?

        fun build(): CodeReviewSummary
        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.MetricsSummary] inside the given [block]
         */
        fun metricsSummary(block: MetricsSummary.DslBuilder.() -> kotlin.Unit) {
            this.metricsSummary = MetricsSummary.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.SourceCodeType] inside the given [block]
         */
        fun sourceCodeType(block: SourceCodeType.DslBuilder.() -> kotlin.Unit) {
            this.sourceCodeType = SourceCodeType.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var codeReviewArn: String? = null
        override var createdTimeStamp: Instant? = null
        override var lastUpdatedTimeStamp: Instant? = null
        override var metricsSummary: MetricsSummary? = null
        override var name: String? = null
        override var owner: String? = null
        override var providerType: ProviderType? = null
        override var pullRequestId: String? = null
        override var repositoryName: String? = null
        override var sourceCodeType: SourceCodeType? = null
        override var state: JobState? = null
        override var type: Type? = null

        constructor(x: CodeReviewSummary) : this() {
            this.codeReviewArn = x.codeReviewArn
            this.createdTimeStamp = x.createdTimeStamp
            this.lastUpdatedTimeStamp = x.lastUpdatedTimeStamp
            this.metricsSummary = x.metricsSummary
            this.name = x.name
            this.owner = x.owner
            this.providerType = x.providerType
            this.pullRequestId = x.pullRequestId
            this.repositoryName = x.repositoryName
            this.sourceCodeType = x.sourceCodeType
            this.state = x.state
            this.type = x.type
        }

        override fun build(): CodeReviewSummary = CodeReviewSummary(this)
        override fun codeReviewArn(codeReviewArn: String): FluentBuilder = apply { this.codeReviewArn = codeReviewArn }
        override fun createdTimeStamp(createdTimeStamp: Instant): FluentBuilder = apply { this.createdTimeStamp = createdTimeStamp }
        override fun lastUpdatedTimeStamp(lastUpdatedTimeStamp: Instant): FluentBuilder = apply { this.lastUpdatedTimeStamp = lastUpdatedTimeStamp }
        override fun metricsSummary(metricsSummary: MetricsSummary): FluentBuilder = apply { this.metricsSummary = metricsSummary }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun owner(owner: String): FluentBuilder = apply { this.owner = owner }
        override fun providerType(providerType: ProviderType): FluentBuilder = apply { this.providerType = providerType }
        override fun pullRequestId(pullRequestId: String): FluentBuilder = apply { this.pullRequestId = pullRequestId }
        override fun repositoryName(repositoryName: String): FluentBuilder = apply { this.repositoryName = repositoryName }
        override fun sourceCodeType(sourceCodeType: SourceCodeType): FluentBuilder = apply { this.sourceCodeType = sourceCodeType }
        override fun state(state: JobState): FluentBuilder = apply { this.state = state }
        override fun type(type: Type): FluentBuilder = apply { this.type = type }
    }
}
