// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model



/**
 * The type of a code review. There are two code review types:
 * PullRequest - A code review that is automatically triggered by a pull request on an associated repository.
 * RepositoryAnalysis - A code review that analyzes all code under a specified
 * branch in an associated repository. The associated repository is specified using its ARN
 * in <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CreateCodeReview">
 * CreateCodeReview
 * .
 */
class CodeReviewType private constructor(builder: BuilderImpl) {
    /**
     * They types of analysis performed during a repository analysis or a pull request review. You can specify either
     * Security, CodeQuality, or both.
     */
    val analysisTypes: List<AnalysisType>? = builder.analysisTypes
    /**
     * A code review that analyzes all code under a specified branch in an associated
     * repository. The associated repository is specified using its ARN in <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CreateCodeReview">
     * CreateCodeReview
     * .
     */
    val repositoryAnalysis: RepositoryAnalysis? = builder.repositoryAnalysis

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CodeReviewType = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CodeReviewType(")
        append("analysisTypes=$analysisTypes,")
        append("repositoryAnalysis=$repositoryAnalysis)")
    }

    override fun hashCode(): kotlin.Int {
        var result = analysisTypes?.hashCode() ?: 0
        result = 31 * result + (repositoryAnalysis?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CodeReviewType

        if (analysisTypes != other.analysisTypes) return false
        if (repositoryAnalysis != other.repositoryAnalysis) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CodeReviewType = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CodeReviewType
        /**
         * They types of analysis performed during a repository analysis or a pull request review. You can specify either
         * Security, CodeQuality, or both.
         */
        fun analysisTypes(analysisTypes: List<AnalysisType>): FluentBuilder
        /**
         * A code review that analyzes all code under a specified branch in an associated
         * repository. The associated repository is specified using its ARN in <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CreateCodeReview">
         * CreateCodeReview
         * .
         */
        fun repositoryAnalysis(repositoryAnalysis: RepositoryAnalysis): FluentBuilder
    }

    interface DslBuilder {
        /**
         * They types of analysis performed during a repository analysis or a pull request review. You can specify either
         * Security, CodeQuality, or both.
         */
        var analysisTypes: List<AnalysisType>?
        /**
         * A code review that analyzes all code under a specified branch in an associated
         * repository. The associated repository is specified using its ARN in <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CreateCodeReview">
         * CreateCodeReview
         * .
         */
        var repositoryAnalysis: RepositoryAnalysis?

        fun build(): CodeReviewType
        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.RepositoryAnalysis] inside the given [block]
         */
        fun repositoryAnalysis(block: RepositoryAnalysis.DslBuilder.() -> kotlin.Unit) {
            this.repositoryAnalysis = RepositoryAnalysis.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var analysisTypes: List<AnalysisType>? = null
        override var repositoryAnalysis: RepositoryAnalysis? = null

        constructor(x: CodeReviewType) : this() {
            this.analysisTypes = x.analysisTypes
            this.repositoryAnalysis = x.repositoryAnalysis
        }

        override fun build(): CodeReviewType = CodeReviewType(this)
        override fun analysisTypes(analysisTypes: List<AnalysisType>): FluentBuilder = apply { this.analysisTypes = analysisTypes }
        override fun repositoryAnalysis(repositoryAnalysis: RepositoryAnalysis): FluentBuilder = apply { this.repositoryAnalysis = repositoryAnalysis }
    }
}
