// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model



/**
 * A type of <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
 * SourceCodeType
 * that
 * specifies the commit diff for a pull request on an associated repository. The SourceCommit
 * and DestinationCommit fields are required to do a pull request code review.
 */
class CommitDiffSourceCodeType private constructor(builder: BuilderImpl) {
    /**
     * The SHA of the destination commit used to generate a commit diff. This field is required for a pull request code review.
     */
    val destinationCommit: String? = builder.destinationCommit
    /**
     * The SHA of the merge base of a commit.
     */
    val mergeBaseCommit: String? = builder.mergeBaseCommit
    /**
     * The SHA of the source commit used to generate a commit diff. This field is required for a pull request code review.
     */
    val sourceCommit: String? = builder.sourceCommit

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CommitDiffSourceCodeType = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CommitDiffSourceCodeType(")
        append("destinationCommit=$destinationCommit,")
        append("mergeBaseCommit=$mergeBaseCommit,")
        append("sourceCommit=$sourceCommit)")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationCommit?.hashCode() ?: 0
        result = 31 * result + (mergeBaseCommit?.hashCode() ?: 0)
        result = 31 * result + (sourceCommit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CommitDiffSourceCodeType

        if (destinationCommit != other.destinationCommit) return false
        if (mergeBaseCommit != other.mergeBaseCommit) return false
        if (sourceCommit != other.sourceCommit) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CommitDiffSourceCodeType = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CommitDiffSourceCodeType
        /**
         * The SHA of the destination commit used to generate a commit diff. This field is required for a pull request code review.
         */
        fun destinationCommit(destinationCommit: String): FluentBuilder
        /**
         * The SHA of the merge base of a commit.
         */
        fun mergeBaseCommit(mergeBaseCommit: String): FluentBuilder
        /**
         * The SHA of the source commit used to generate a commit diff. This field is required for a pull request code review.
         */
        fun sourceCommit(sourceCommit: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The SHA of the destination commit used to generate a commit diff. This field is required for a pull request code review.
         */
        var destinationCommit: String?
        /**
         * The SHA of the merge base of a commit.
         */
        var mergeBaseCommit: String?
        /**
         * The SHA of the source commit used to generate a commit diff. This field is required for a pull request code review.
         */
        var sourceCommit: String?

        fun build(): CommitDiffSourceCodeType
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var destinationCommit: String? = null
        override var mergeBaseCommit: String? = null
        override var sourceCommit: String? = null

        constructor(x: CommitDiffSourceCodeType) : this() {
            this.destinationCommit = x.destinationCommit
            this.mergeBaseCommit = x.mergeBaseCommit
            this.sourceCommit = x.sourceCommit
        }

        override fun build(): CommitDiffSourceCodeType = CommitDiffSourceCodeType(this)
        override fun destinationCommit(destinationCommit: String): FluentBuilder = apply { this.destinationCommit = destinationCommit }
        override fun mergeBaseCommit(mergeBaseCommit: String): FluentBuilder = apply { this.mergeBaseCommit = mergeBaseCommit }
        override fun sourceCommit(sourceCommit: String): FluentBuilder = apply { this.sourceCommit = sourceCommit }
    }
}
