// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model



class CreateCodeReviewRequest private constructor(builder: BuilderImpl) {
    /**
     * Amazon CodeGuru Reviewer uses this value to prevent the accidental creation of duplicate code
     * reviews if there are failures and retries.
     */
    val clientRequestToken: String? = builder.clientRequestToken
    /**
     * The name of the code review. The name of each code review in your Amazon Web Services account must be unique.
     */
    val name: String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the
     * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
     * RepositoryAssociation
     * object.
     * You can retrieve this ARN by calling
     * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
     * ListRepositoryAssociations
     * .
     * A code review can only be created on an associated repository. This is the ARN of the
     * associated repository.
     */
    val repositoryAssociationArn: String? = builder.repositoryAssociationArn
    /**
     * The type of code review to create. This is specified using a
     * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReviewType.html">
     * CodeReviewType
     * object. You can create a code review only of type RepositoryAnalysis.
     */
    val type: CodeReviewType? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateCodeReviewRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateCodeReviewRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("name=$name,")
        append("repositoryAssociationArn=$repositoryAssociationArn,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (repositoryAssociationArn?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateCodeReviewRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (name != other.name) return false
        if (repositoryAssociationArn != other.repositoryAssociationArn) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateCodeReviewRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateCodeReviewRequest
        /**
         * Amazon CodeGuru Reviewer uses this value to prevent the accidental creation of duplicate code
         * reviews if there are failures and retries.
         */
        fun clientRequestToken(clientRequestToken: String): FluentBuilder
        /**
         * The name of the code review. The name of each code review in your Amazon Web Services account must be unique.
         */
        fun name(name: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the
         * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
         * RepositoryAssociation
         * object.
         * You can retrieve this ARN by calling
         * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
         * ListRepositoryAssociations
         * .
         * A code review can only be created on an associated repository. This is the ARN of the
         * associated repository.
         */
        fun repositoryAssociationArn(repositoryAssociationArn: String): FluentBuilder
        /**
         * The type of code review to create. This is specified using a
         * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReviewType.html">
         * CodeReviewType
         * object. You can create a code review only of type RepositoryAnalysis.
         */
        fun type(type: CodeReviewType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Amazon CodeGuru Reviewer uses this value to prevent the accidental creation of duplicate code
         * reviews if there are failures and retries.
         */
        var clientRequestToken: String?
        /**
         * The name of the code review. The name of each code review in your Amazon Web Services account must be unique.
         */
        var name: String?
        /**
         * The Amazon Resource Name (ARN) of the
         * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
         * RepositoryAssociation
         * object.
         * You can retrieve this ARN by calling
         * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
         * ListRepositoryAssociations
         * .
         * A code review can only be created on an associated repository. This is the ARN of the
         * associated repository.
         */
        var repositoryAssociationArn: String?
        /**
         * The type of code review to create. This is specified using a
         * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReviewType.html">
         * CodeReviewType
         * object. You can create a code review only of type RepositoryAnalysis.
         */
        var type: CodeReviewType?

        fun build(): CreateCodeReviewRequest
        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.CodeReviewType] inside the given [block]
         */
        fun type(block: CodeReviewType.DslBuilder.() -> kotlin.Unit) {
            this.type = CodeReviewType.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientRequestToken: String? = null
        override var name: String? = null
        override var repositoryAssociationArn: String? = null
        override var type: CodeReviewType? = null

        constructor(x: CreateCodeReviewRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.name = x.name
            this.repositoryAssociationArn = x.repositoryAssociationArn
            this.type = x.type
        }

        override fun build(): CreateCodeReviewRequest = CreateCodeReviewRequest(this)
        override fun clientRequestToken(clientRequestToken: String): FluentBuilder = apply { this.clientRequestToken = clientRequestToken }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun repositoryAssociationArn(repositoryAssociationArn: String): FluentBuilder = apply { this.repositoryAssociationArn = repositoryAssociationArn }
        override fun type(type: CodeReviewType): FluentBuilder = apply { this.type = type }
    }
}
