// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model



class ListRecommendationFeedbackRequest private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
     * CodeReview
     * object.
     */
    val codeReviewArn: String? = builder.codeReviewArn
    /**
     * The maximum number of results that are returned per call. The default is 100.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page.
     * Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged.
     */
    val nextToken: String? = builder.nextToken
    /**
     * Used to query the recommendation feedback for a given recommendation.
     */
    val recommendationIds: List<String>? = builder.recommendationIds
    /**
     * An Amazon Web Services user's account ID or Amazon Resource Name (ARN). Use this ID to query the recommendation feedback for a code review from that user.
     * The UserId is an IAM principal that can be specified as an Amazon Web Services account ID or an Amazon Resource Name (ARN). For
     * more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying">
     * Specifying a Principal in the Amazon Web Services Identity and Access Management User Guide.
     */
    val userIds: List<String>? = builder.userIds

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListRecommendationFeedbackRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListRecommendationFeedbackRequest(")
        append("codeReviewArn=$codeReviewArn,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("recommendationIds=$recommendationIds,")
        append("userIds=$userIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = codeReviewArn?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (recommendationIds?.hashCode() ?: 0)
        result = 31 * result + (userIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListRecommendationFeedbackRequest

        if (codeReviewArn != other.codeReviewArn) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (recommendationIds != other.recommendationIds) return false
        if (userIds != other.userIds) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListRecommendationFeedbackRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListRecommendationFeedbackRequest
        /**
         * The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
         * CodeReview
         * object.
         */
        fun codeReviewArn(codeReviewArn: String): FluentBuilder
        /**
         * The maximum number of results that are returned per call. The default is 100.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page.
         * Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * Used to query the recommendation feedback for a given recommendation.
         */
        fun recommendationIds(recommendationIds: List<String>): FluentBuilder
        /**
         * An Amazon Web Services user's account ID or Amazon Resource Name (ARN). Use this ID to query the recommendation feedback for a code review from that user.
         * The UserId is an IAM principal that can be specified as an Amazon Web Services account ID or an Amazon Resource Name (ARN). For
         * more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying">
         * Specifying a Principal in the Amazon Web Services Identity and Access Management User Guide.
         */
        fun userIds(userIds: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
         * CodeReview
         * object.
         */
        var codeReviewArn: String?
        /**
         * The maximum number of results that are returned per call. The default is 100.
         */
        var maxResults: Int?
        /**
         * If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page.
         * Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged.
         */
        var nextToken: String?
        /**
         * Used to query the recommendation feedback for a given recommendation.
         */
        var recommendationIds: List<String>?
        /**
         * An Amazon Web Services user's account ID or Amazon Resource Name (ARN). Use this ID to query the recommendation feedback for a code review from that user.
         * The UserId is an IAM principal that can be specified as an Amazon Web Services account ID or an Amazon Resource Name (ARN). For
         * more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying">
         * Specifying a Principal in the Amazon Web Services Identity and Access Management User Guide.
         */
        var userIds: List<String>?

        fun build(): ListRecommendationFeedbackRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var codeReviewArn: String? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var recommendationIds: List<String>? = null
        override var userIds: List<String>? = null

        constructor(x: ListRecommendationFeedbackRequest) : this() {
            this.codeReviewArn = x.codeReviewArn
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.recommendationIds = x.recommendationIds
            this.userIds = x.userIds
        }

        override fun build(): ListRecommendationFeedbackRequest = ListRecommendationFeedbackRequest(this)
        override fun codeReviewArn(codeReviewArn: String): FluentBuilder = apply { this.codeReviewArn = codeReviewArn }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun recommendationIds(recommendationIds: List<String>): FluentBuilder = apply { this.recommendationIds = recommendationIds }
        override fun userIds(userIds: List<String>): FluentBuilder = apply { this.userIds = userIds }
    }
}
