// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about the recommendation feedback.
 */
class RecommendationFeedback private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
     * CodeReview
     * object.
     */
    val codeReviewArn: String? = builder.codeReviewArn
    /**
     * The time at which the feedback was created.
     */
    val createdTimeStamp: Instant? = builder.createdTimeStamp
    /**
     * The time at which the feedback was last updated.
     */
    val lastUpdatedTimeStamp: Instant? = builder.lastUpdatedTimeStamp
    /**
     * List for storing reactions. Reactions are utf-8 text code for emojis. You can send an empty list to clear off all your feedback.
     */
    val reactions: List<Reaction>? = builder.reactions
    /**
     * The recommendation ID that can be used to track the provided recommendations. Later on it can be used to collect the feedback.
     */
    val recommendationId: String? = builder.recommendationId
    /**
     * The ID of the user that made the API call.
     * The UserId is an IAM principal that can be specified as an Amazon Web Services account ID or an Amazon Resource Name (ARN). For
     * more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying">
     * Specifying a Principal in the Amazon Web Services Identity and Access Management User Guide.
     */
    val userId: String? = builder.userId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RecommendationFeedback = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RecommendationFeedback(")
        append("codeReviewArn=$codeReviewArn,")
        append("createdTimeStamp=$createdTimeStamp,")
        append("lastUpdatedTimeStamp=$lastUpdatedTimeStamp,")
        append("reactions=$reactions,")
        append("recommendationId=$recommendationId,")
        append("userId=$userId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = codeReviewArn?.hashCode() ?: 0
        result = 31 * result + (createdTimeStamp?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTimeStamp?.hashCode() ?: 0)
        result = 31 * result + (reactions?.hashCode() ?: 0)
        result = 31 * result + (recommendationId?.hashCode() ?: 0)
        result = 31 * result + (userId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RecommendationFeedback

        if (codeReviewArn != other.codeReviewArn) return false
        if (createdTimeStamp != other.createdTimeStamp) return false
        if (lastUpdatedTimeStamp != other.lastUpdatedTimeStamp) return false
        if (reactions != other.reactions) return false
        if (recommendationId != other.recommendationId) return false
        if (userId != other.userId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RecommendationFeedback = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RecommendationFeedback
        /**
         * The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
         * CodeReview
         * object.
         */
        fun codeReviewArn(codeReviewArn: String): FluentBuilder
        /**
         * The time at which the feedback was created.
         */
        fun createdTimeStamp(createdTimeStamp: Instant): FluentBuilder
        /**
         * The time at which the feedback was last updated.
         */
        fun lastUpdatedTimeStamp(lastUpdatedTimeStamp: Instant): FluentBuilder
        /**
         * List for storing reactions. Reactions are utf-8 text code for emojis. You can send an empty list to clear off all your feedback.
         */
        fun reactions(reactions: List<Reaction>): FluentBuilder
        /**
         * The recommendation ID that can be used to track the provided recommendations. Later on it can be used to collect the feedback.
         */
        fun recommendationId(recommendationId: String): FluentBuilder
        /**
         * The ID of the user that made the API call.
         * The UserId is an IAM principal that can be specified as an Amazon Web Services account ID or an Amazon Resource Name (ARN). For
         * more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying">
         * Specifying a Principal in the Amazon Web Services Identity and Access Management User Guide.
         */
        fun userId(userId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html">
         * CodeReview
         * object.
         */
        var codeReviewArn: String?
        /**
         * The time at which the feedback was created.
         */
        var createdTimeStamp: Instant?
        /**
         * The time at which the feedback was last updated.
         */
        var lastUpdatedTimeStamp: Instant?
        /**
         * List for storing reactions. Reactions are utf-8 text code for emojis. You can send an empty list to clear off all your feedback.
         */
        var reactions: List<Reaction>?
        /**
         * The recommendation ID that can be used to track the provided recommendations. Later on it can be used to collect the feedback.
         */
        var recommendationId: String?
        /**
         * The ID of the user that made the API call.
         * The UserId is an IAM principal that can be specified as an Amazon Web Services account ID or an Amazon Resource Name (ARN). For
         * more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying">
         * Specifying a Principal in the Amazon Web Services Identity and Access Management User Guide.
         */
        var userId: String?

        fun build(): RecommendationFeedback
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var codeReviewArn: String? = null
        override var createdTimeStamp: Instant? = null
        override var lastUpdatedTimeStamp: Instant? = null
        override var reactions: List<Reaction>? = null
        override var recommendationId: String? = null
        override var userId: String? = null

        constructor(x: RecommendationFeedback) : this() {
            this.codeReviewArn = x.codeReviewArn
            this.createdTimeStamp = x.createdTimeStamp
            this.lastUpdatedTimeStamp = x.lastUpdatedTimeStamp
            this.reactions = x.reactions
            this.recommendationId = x.recommendationId
            this.userId = x.userId
        }

        override fun build(): RecommendationFeedback = RecommendationFeedback(this)
        override fun codeReviewArn(codeReviewArn: String): FluentBuilder = apply { this.codeReviewArn = codeReviewArn }
        override fun createdTimeStamp(createdTimeStamp: Instant): FluentBuilder = apply { this.createdTimeStamp = createdTimeStamp }
        override fun lastUpdatedTimeStamp(lastUpdatedTimeStamp: Instant): FluentBuilder = apply { this.lastUpdatedTimeStamp = lastUpdatedTimeStamp }
        override fun reactions(reactions: List<Reaction>): FluentBuilder = apply { this.reactions = reactions }
        override fun recommendationId(recommendationId: String): FluentBuilder = apply { this.recommendationId = recommendationId }
        override fun userId(userId: String): FluentBuilder = apply { this.userId = userId }
    }
}
