// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model



/**
 * Information about recommendation feedback summaries.
 */
class RecommendationFeedbackSummary private constructor(builder: BuilderImpl) {
    /**
     * List for storing reactions. Reactions are utf-8 text code for emojis.
     */
    val reactions: List<Reaction>? = builder.reactions
    /**
     * The recommendation ID that can be used to track the provided recommendations. Later on it can be used to collect the feedback.
     */
    val recommendationId: String? = builder.recommendationId
    /**
     * The ID of the user that gave the feedback.
     * The UserId is an IAM principal that can be specified as an Amazon Web Services account ID or an Amazon Resource Name (ARN). For
     * more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying">
     * Specifying a Principal in the Amazon Web Services Identity and Access Management User Guide.
     */
    val userId: String? = builder.userId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RecommendationFeedbackSummary = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RecommendationFeedbackSummary(")
        append("reactions=$reactions,")
        append("recommendationId=$recommendationId,")
        append("userId=$userId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = reactions?.hashCode() ?: 0
        result = 31 * result + (recommendationId?.hashCode() ?: 0)
        result = 31 * result + (userId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RecommendationFeedbackSummary

        if (reactions != other.reactions) return false
        if (recommendationId != other.recommendationId) return false
        if (userId != other.userId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RecommendationFeedbackSummary = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RecommendationFeedbackSummary
        /**
         * List for storing reactions. Reactions are utf-8 text code for emojis.
         */
        fun reactions(reactions: List<Reaction>): FluentBuilder
        /**
         * The recommendation ID that can be used to track the provided recommendations. Later on it can be used to collect the feedback.
         */
        fun recommendationId(recommendationId: String): FluentBuilder
        /**
         * The ID of the user that gave the feedback.
         * The UserId is an IAM principal that can be specified as an Amazon Web Services account ID or an Amazon Resource Name (ARN). For
         * more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying">
         * Specifying a Principal in the Amazon Web Services Identity and Access Management User Guide.
         */
        fun userId(userId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * List for storing reactions. Reactions are utf-8 text code for emojis.
         */
        var reactions: List<Reaction>?
        /**
         * The recommendation ID that can be used to track the provided recommendations. Later on it can be used to collect the feedback.
         */
        var recommendationId: String?
        /**
         * The ID of the user that gave the feedback.
         * The UserId is an IAM principal that can be specified as an Amazon Web Services account ID or an Amazon Resource Name (ARN). For
         * more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying">
         * Specifying a Principal in the Amazon Web Services Identity and Access Management User Guide.
         */
        var userId: String?

        fun build(): RecommendationFeedbackSummary
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var reactions: List<Reaction>? = null
        override var recommendationId: String? = null
        override var userId: String? = null

        constructor(x: RecommendationFeedbackSummary) : this() {
            this.reactions = x.reactions
            this.recommendationId = x.recommendationId
            this.userId = x.userId
        }

        override fun build(): RecommendationFeedbackSummary = RecommendationFeedbackSummary(this)
        override fun reactions(reactions: List<Reaction>): FluentBuilder = apply { this.reactions = reactions }
        override fun recommendationId(recommendationId: String): FluentBuilder = apply { this.recommendationId = recommendationId }
        override fun userId(userId: String): FluentBuilder = apply { this.userId = userId }
    }
}
