// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model



/**
 * Information about recommendations.
 */
class RecommendationSummary private constructor(builder: BuilderImpl) {
    /**
     * A description of the recommendation generated by CodeGuru Reviewer for the lines of code between the start line and the end line.
     */
    val description: String? = builder.description
    /**
     * Last line where the recommendation is applicable in the source commit or source branch. For a single line comment the start line and end line values are the same.
     */
    val endLine: Int? = builder.endLine
    /**
     * Name of the file on which a recommendation is provided.
     */
    val filePath: String? = builder.filePath
    /**
     * The type of a recommendation.
     */
    val recommendationCategory: RecommendationCategory? = builder.recommendationCategory
    /**
     * The recommendation ID that can be used to track the provided recommendations. Later on it can be used to collect the feedback.
     */
    val recommendationId: String? = builder.recommendationId
    /**
     * Metadata about a rule. Rule metadata includes an ID, a name, a list of tags, and a
     * short and long description. CodeGuru Reviewer uses rules to analyze code. A rule's recommendation is
     * included in analysis results if code is detected that violates the rule.
     */
    val ruleMetadata: RuleMetadata? = builder.ruleMetadata
    /**
     * The severity of the issue in the code that generated this recommendation.
     */
    val severity: Severity? = builder.severity
    /**
     * Start line from where the recommendation is applicable in the source commit or source branch.
     */
    val startLine: Int? = builder.startLine

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RecommendationSummary = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RecommendationSummary(")
        append("description=$description,")
        append("endLine=$endLine,")
        append("filePath=$filePath,")
        append("recommendationCategory=$recommendationCategory,")
        append("recommendationId=$recommendationId,")
        append("ruleMetadata=$ruleMetadata,")
        append("severity=$severity,")
        append("startLine=$startLine)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (endLine ?: 0)
        result = 31 * result + (filePath?.hashCode() ?: 0)
        result = 31 * result + (recommendationCategory?.hashCode() ?: 0)
        result = 31 * result + (recommendationId?.hashCode() ?: 0)
        result = 31 * result + (ruleMetadata?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        result = 31 * result + (startLine ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RecommendationSummary

        if (description != other.description) return false
        if (endLine != other.endLine) return false
        if (filePath != other.filePath) return false
        if (recommendationCategory != other.recommendationCategory) return false
        if (recommendationId != other.recommendationId) return false
        if (ruleMetadata != other.ruleMetadata) return false
        if (severity != other.severity) return false
        if (startLine != other.startLine) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RecommendationSummary = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RecommendationSummary
        /**
         * A description of the recommendation generated by CodeGuru Reviewer for the lines of code between the start line and the end line.
         */
        fun description(description: String): FluentBuilder
        /**
         * Last line where the recommendation is applicable in the source commit or source branch. For a single line comment the start line and end line values are the same.
         */
        fun endLine(endLine: Int): FluentBuilder
        /**
         * Name of the file on which a recommendation is provided.
         */
        fun filePath(filePath: String): FluentBuilder
        /**
         * The type of a recommendation.
         */
        fun recommendationCategory(recommendationCategory: RecommendationCategory): FluentBuilder
        /**
         * The recommendation ID that can be used to track the provided recommendations. Later on it can be used to collect the feedback.
         */
        fun recommendationId(recommendationId: String): FluentBuilder
        /**
         * Metadata about a rule. Rule metadata includes an ID, a name, a list of tags, and a
         * short and long description. CodeGuru Reviewer uses rules to analyze code. A rule's recommendation is
         * included in analysis results if code is detected that violates the rule.
         */
        fun ruleMetadata(ruleMetadata: RuleMetadata): FluentBuilder
        /**
         * The severity of the issue in the code that generated this recommendation.
         */
        fun severity(severity: Severity): FluentBuilder
        /**
         * Start line from where the recommendation is applicable in the source commit or source branch.
         */
        fun startLine(startLine: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A description of the recommendation generated by CodeGuru Reviewer for the lines of code between the start line and the end line.
         */
        var description: String?
        /**
         * Last line where the recommendation is applicable in the source commit or source branch. For a single line comment the start line and end line values are the same.
         */
        var endLine: Int?
        /**
         * Name of the file on which a recommendation is provided.
         */
        var filePath: String?
        /**
         * The type of a recommendation.
         */
        var recommendationCategory: RecommendationCategory?
        /**
         * The recommendation ID that can be used to track the provided recommendations. Later on it can be used to collect the feedback.
         */
        var recommendationId: String?
        /**
         * Metadata about a rule. Rule metadata includes an ID, a name, a list of tags, and a
         * short and long description. CodeGuru Reviewer uses rules to analyze code. A rule's recommendation is
         * included in analysis results if code is detected that violates the rule.
         */
        var ruleMetadata: RuleMetadata?
        /**
         * The severity of the issue in the code that generated this recommendation.
         */
        var severity: Severity?
        /**
         * Start line from where the recommendation is applicable in the source commit or source branch.
         */
        var startLine: Int?

        fun build(): RecommendationSummary
        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.RuleMetadata] inside the given [block]
         */
        fun ruleMetadata(block: RuleMetadata.DslBuilder.() -> kotlin.Unit) {
            this.ruleMetadata = RuleMetadata.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var description: String? = null
        override var endLine: Int? = null
        override var filePath: String? = null
        override var recommendationCategory: RecommendationCategory? = null
        override var recommendationId: String? = null
        override var ruleMetadata: RuleMetadata? = null
        override var severity: Severity? = null
        override var startLine: Int? = null

        constructor(x: RecommendationSummary) : this() {
            this.description = x.description
            this.endLine = x.endLine
            this.filePath = x.filePath
            this.recommendationCategory = x.recommendationCategory
            this.recommendationId = x.recommendationId
            this.ruleMetadata = x.ruleMetadata
            this.severity = x.severity
            this.startLine = x.startLine
        }

        override fun build(): RecommendationSummary = RecommendationSummary(this)
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun endLine(endLine: Int): FluentBuilder = apply { this.endLine = endLine }
        override fun filePath(filePath: String): FluentBuilder = apply { this.filePath = filePath }
        override fun recommendationCategory(recommendationCategory: RecommendationCategory): FluentBuilder = apply { this.recommendationCategory = recommendationCategory }
        override fun recommendationId(recommendationId: String): FluentBuilder = apply { this.recommendationId = recommendationId }
        override fun ruleMetadata(ruleMetadata: RuleMetadata): FluentBuilder = apply { this.ruleMetadata = ruleMetadata }
        override fun severity(severity: Severity): FluentBuilder = apply { this.severity = severity }
        override fun startLine(startLine: Int): FluentBuilder = apply { this.startLine = startLine }
    }
}
