// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model



/**
 * Information about an associated Amazon Web Services CodeCommit repository or an associated repository that is managed
 * by Amazon Web Services CodeStar Connections (for example, Bitbucket). This Repository object
 * is not used if your source code is in an associated GitHub repository.
 */
class Repository private constructor(builder: BuilderImpl) {
    /**
     * Information about a Bitbucket repository.
     */
    val bitbucket: ThirdPartySourceRepository? = builder.bitbucket
    /**
     * Information about an Amazon Web Services CodeCommit repository.
     */
    val codeCommit: CodeCommitRepository? = builder.codeCommit
    /**
     * Information about a GitHub Enterprise Server repository.
     */
    val gitHubEnterpriseServer: ThirdPartySourceRepository? = builder.gitHubEnterpriseServer
    /**
     * Information about a repository in an S3 bucket.
     */
    val s3Bucket: S3Repository? = builder.s3Bucket

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Repository = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Repository(")
        append("bitbucket=$bitbucket,")
        append("codeCommit=$codeCommit,")
        append("gitHubEnterpriseServer=$gitHubEnterpriseServer,")
        append("s3Bucket=$s3Bucket)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bitbucket?.hashCode() ?: 0
        result = 31 * result + (codeCommit?.hashCode() ?: 0)
        result = 31 * result + (gitHubEnterpriseServer?.hashCode() ?: 0)
        result = 31 * result + (s3Bucket?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Repository

        if (bitbucket != other.bitbucket) return false
        if (codeCommit != other.codeCommit) return false
        if (gitHubEnterpriseServer != other.gitHubEnterpriseServer) return false
        if (s3Bucket != other.s3Bucket) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Repository = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Repository
        /**
         * Information about a Bitbucket repository.
         */
        fun bitbucket(bitbucket: ThirdPartySourceRepository): FluentBuilder
        /**
         * Information about an Amazon Web Services CodeCommit repository.
         */
        fun codeCommit(codeCommit: CodeCommitRepository): FluentBuilder
        /**
         * Information about a GitHub Enterprise Server repository.
         */
        fun gitHubEnterpriseServer(gitHubEnterpriseServer: ThirdPartySourceRepository): FluentBuilder
        /**
         * Information about a repository in an S3 bucket.
         */
        fun s3Bucket(s3Bucket: S3Repository): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Information about a Bitbucket repository.
         */
        var bitbucket: ThirdPartySourceRepository?
        /**
         * Information about an Amazon Web Services CodeCommit repository.
         */
        var codeCommit: CodeCommitRepository?
        /**
         * Information about a GitHub Enterprise Server repository.
         */
        var gitHubEnterpriseServer: ThirdPartySourceRepository?
        /**
         * Information about a repository in an S3 bucket.
         */
        var s3Bucket: S3Repository?

        fun build(): Repository
        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.ThirdPartySourceRepository] inside the given [block]
         */
        fun bitbucket(block: ThirdPartySourceRepository.DslBuilder.() -> kotlin.Unit) {
            this.bitbucket = ThirdPartySourceRepository.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.CodeCommitRepository] inside the given [block]
         */
        fun codeCommit(block: CodeCommitRepository.DslBuilder.() -> kotlin.Unit) {
            this.codeCommit = CodeCommitRepository.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.ThirdPartySourceRepository] inside the given [block]
         */
        fun gitHubEnterpriseServer(block: ThirdPartySourceRepository.DslBuilder.() -> kotlin.Unit) {
            this.gitHubEnterpriseServer = ThirdPartySourceRepository.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.S3Repository] inside the given [block]
         */
        fun s3Bucket(block: S3Repository.DslBuilder.() -> kotlin.Unit) {
            this.s3Bucket = S3Repository.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var bitbucket: ThirdPartySourceRepository? = null
        override var codeCommit: CodeCommitRepository? = null
        override var gitHubEnterpriseServer: ThirdPartySourceRepository? = null
        override var s3Bucket: S3Repository? = null

        constructor(x: Repository) : this() {
            this.bitbucket = x.bitbucket
            this.codeCommit = x.codeCommit
            this.gitHubEnterpriseServer = x.gitHubEnterpriseServer
            this.s3Bucket = x.s3Bucket
        }

        override fun build(): Repository = Repository(this)
        override fun bitbucket(bitbucket: ThirdPartySourceRepository): FluentBuilder = apply { this.bitbucket = bitbucket }
        override fun codeCommit(codeCommit: CodeCommitRepository): FluentBuilder = apply { this.codeCommit = codeCommit }
        override fun gitHubEnterpriseServer(gitHubEnterpriseServer: ThirdPartySourceRepository): FluentBuilder = apply { this.gitHubEnterpriseServer = gitHubEnterpriseServer }
        override fun s3Bucket(s3Bucket: S3Repository): FluentBuilder = apply { this.s3Bucket = s3Bucket }
    }
}
