// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model



/**
 * A code review type that analyzes all code under a specified branch in an associated
 * repository. The associated repository is specified using its ARN when you call <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CreateCodeReview">
 * CreateCodeReview
 * .
 */
class RepositoryAnalysis private constructor(builder: BuilderImpl) {
    /**
     * A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
     * SourceCodeType
     * that
     * specifies the tip of a branch in an associated repository.
     */
    val repositoryHead: RepositoryHeadSourceCodeType? = builder.repositoryHead
    /**
     * Specifies the source code that is analyzed in a code review.
     */
    val sourceCodeType: SourceCodeType? = builder.sourceCodeType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RepositoryAnalysis = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RepositoryAnalysis(")
        append("repositoryHead=$repositoryHead,")
        append("sourceCodeType=$sourceCodeType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = repositoryHead?.hashCode() ?: 0
        result = 31 * result + (sourceCodeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RepositoryAnalysis

        if (repositoryHead != other.repositoryHead) return false
        if (sourceCodeType != other.sourceCodeType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RepositoryAnalysis = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RepositoryAnalysis
        /**
         * A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
         * SourceCodeType
         * that
         * specifies the tip of a branch in an associated repository.
         */
        fun repositoryHead(repositoryHead: RepositoryHeadSourceCodeType): FluentBuilder
        /**
         * Specifies the source code that is analyzed in a code review.
         */
        fun sourceCodeType(sourceCodeType: SourceCodeType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
         * SourceCodeType
         * that
         * specifies the tip of a branch in an associated repository.
         */
        var repositoryHead: RepositoryHeadSourceCodeType?
        /**
         * Specifies the source code that is analyzed in a code review.
         */
        var sourceCodeType: SourceCodeType?

        fun build(): RepositoryAnalysis
        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.RepositoryHeadSourceCodeType] inside the given [block]
         */
        fun repositoryHead(block: RepositoryHeadSourceCodeType.DslBuilder.() -> kotlin.Unit) {
            this.repositoryHead = RepositoryHeadSourceCodeType.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.SourceCodeType] inside the given [block]
         */
        fun sourceCodeType(block: SourceCodeType.DslBuilder.() -> kotlin.Unit) {
            this.sourceCodeType = SourceCodeType.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var repositoryHead: RepositoryHeadSourceCodeType? = null
        override var sourceCodeType: SourceCodeType? = null

        constructor(x: RepositoryAnalysis) : this() {
            this.repositoryHead = x.repositoryHead
            this.sourceCodeType = x.sourceCodeType
        }

        override fun build(): RepositoryAnalysis = RepositoryAnalysis(this)
        override fun repositoryHead(repositoryHead: RepositoryHeadSourceCodeType): FluentBuilder = apply { this.repositoryHead = repositoryHead }
        override fun sourceCodeType(sourceCodeType: SourceCodeType): FluentBuilder = apply { this.sourceCodeType = sourceCodeType }
    }
}
