// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a repository association. The
 * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_DescribeRepositoryAssociation.html">
 * DescribeRepositoryAssociation
 * operation returns a RepositoryAssociation object.
 */
class RepositoryAssociation private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) identifying the repository association.
     */
    val associationArn: String? = builder.associationArn
    /**
     * The ID of the repository association.
     */
    val associationId: String? = builder.associationId
    /**
     * The Amazon Resource Name (ARN) of an Amazon Web Services CodeStar Connections connection. Its format is
     * arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id. For more information, see
     * <a href="https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html">
     * Connection
     * in
     * the Amazon Web Services CodeStar Connections API Reference.
     */
    val connectionArn: String? = builder.connectionArn
    /**
     * The time, in milliseconds since the epoch, when the repository association was created.
     */
    val createdTimeStamp: Instant? = builder.createdTimeStamp
    /**
     * A KMSKeyDetails object that contains:
     * The encryption option for this repository association. It is either owned by Amazon Web Services
     * Key Management Service (KMS) (AWS_OWNED_CMK) or customer managed (CUSTOMER_MANAGED_CMK).
     * The ID of the Amazon Web Services KMS key that
     * is associated with this respository association.
     */
    val kmsKeyDetails: KmsKeyDetails? = builder.kmsKeyDetails
    /**
     * The time, in milliseconds since the epoch, when the repository association was last updated.
     */
    val lastUpdatedTimeStamp: Instant? = builder.lastUpdatedTimeStamp
    /**
     * The name of the repository.
     */
    val name: String? = builder.name
    /**
     * The owner of the repository. For an Amazon Web Services CodeCommit repository, this is the Amazon Web Services account ID of the
     * account that owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository, this is the username for the account that owns the repository.
     * For an S3 repository, it can be the username or Amazon Web Services account ID.
     */
    val owner: String? = builder.owner
    /**
     * The provider type of the repository association.
     */
    val providerType: ProviderType? = builder.providerType
    /**
     * Specifies the name of an S3 bucket and a CodeArtifacts object that contains the S3
     * object keys for a source code .zip file and for a build artifacts .zip file that contains .jar or .class files.
     */
    val s3RepositoryDetails: S3RepositoryDetails? = builder.s3RepositoryDetails
    /**
     * The state of the repository association.
     * The valid repository association states are:
     * Associated: The repository
     * association is complete.
     * Associating: CodeGuru Reviewer is:
     * Setting up pull request notifications. This is required
     * for pull requests to trigger a CodeGuru Reviewer review.
     * If your repository ProviderType is GitHub, GitHub Enterprise Server, or Bitbucket,
     * CodeGuru Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you delete these webhooks,
     * reviews of code in your repository cannot be triggered.
     * Setting up source code access. This is required for CodeGuru Reviewer to securely
     * clone code in your repository.
     * Failed: The repository failed to associate or disassociate.
     * Disassociating: CodeGuru Reviewer is removing the repository's pull request notifications and
     * source code access.
     * Disassociated: CodeGuru Reviewer successfully disassociated the repository. You can create a new association
     * with this repository if you want to review source code in it later. You can control access to code reviews created in an
     * associated repository with tags after it has been disassociated. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/auth-and-access-control-using-tags.html">Using tags to control access to
     * associated repositories in the Amazon CodeGuru Reviewer User Guide.
     */
    val state: RepositoryAssociationState? = builder.state
    /**
     * A description of why the repository association is in the current state.
     */
    val stateReason: String? = builder.stateReason

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RepositoryAssociation = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RepositoryAssociation(")
        append("associationArn=$associationArn,")
        append("associationId=$associationId,")
        append("connectionArn=$connectionArn,")
        append("createdTimeStamp=$createdTimeStamp,")
        append("kmsKeyDetails=$kmsKeyDetails,")
        append("lastUpdatedTimeStamp=$lastUpdatedTimeStamp,")
        append("name=$name,")
        append("owner=$owner,")
        append("providerType=$providerType,")
        append("s3RepositoryDetails=$s3RepositoryDetails,")
        append("state=$state,")
        append("stateReason=$stateReason)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associationArn?.hashCode() ?: 0
        result = 31 * result + (associationId?.hashCode() ?: 0)
        result = 31 * result + (connectionArn?.hashCode() ?: 0)
        result = 31 * result + (createdTimeStamp?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyDetails?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTimeStamp?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (providerType?.hashCode() ?: 0)
        result = 31 * result + (s3RepositoryDetails?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RepositoryAssociation

        if (associationArn != other.associationArn) return false
        if (associationId != other.associationId) return false
        if (connectionArn != other.connectionArn) return false
        if (createdTimeStamp != other.createdTimeStamp) return false
        if (kmsKeyDetails != other.kmsKeyDetails) return false
        if (lastUpdatedTimeStamp != other.lastUpdatedTimeStamp) return false
        if (name != other.name) return false
        if (owner != other.owner) return false
        if (providerType != other.providerType) return false
        if (s3RepositoryDetails != other.s3RepositoryDetails) return false
        if (state != other.state) return false
        if (stateReason != other.stateReason) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RepositoryAssociation = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RepositoryAssociation
        /**
         * The Amazon Resource Name (ARN) identifying the repository association.
         */
        fun associationArn(associationArn: String): FluentBuilder
        /**
         * The ID of the repository association.
         */
        fun associationId(associationId: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of an Amazon Web Services CodeStar Connections connection. Its format is
         * arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id. For more information, see
         * <a href="https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html">
         * Connection
         * in
         * the Amazon Web Services CodeStar Connections API Reference.
         */
        fun connectionArn(connectionArn: String): FluentBuilder
        /**
         * The time, in milliseconds since the epoch, when the repository association was created.
         */
        fun createdTimeStamp(createdTimeStamp: Instant): FluentBuilder
        /**
         * A KMSKeyDetails object that contains:
         * The encryption option for this repository association. It is either owned by Amazon Web Services
         * Key Management Service (KMS) (AWS_OWNED_CMK) or customer managed (CUSTOMER_MANAGED_CMK).
         * The ID of the Amazon Web Services KMS key that
         * is associated with this respository association.
         */
        fun kmsKeyDetails(kmsKeyDetails: KmsKeyDetails): FluentBuilder
        /**
         * The time, in milliseconds since the epoch, when the repository association was last updated.
         */
        fun lastUpdatedTimeStamp(lastUpdatedTimeStamp: Instant): FluentBuilder
        /**
         * The name of the repository.
         */
        fun name(name: String): FluentBuilder
        /**
         * The owner of the repository. For an Amazon Web Services CodeCommit repository, this is the Amazon Web Services account ID of the
         * account that owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository, this is the username for the account that owns the repository.
         * For an S3 repository, it can be the username or Amazon Web Services account ID.
         */
        fun owner(owner: String): FluentBuilder
        /**
         * The provider type of the repository association.
         */
        fun providerType(providerType: ProviderType): FluentBuilder
        /**
         * Specifies the name of an S3 bucket and a CodeArtifacts object that contains the S3
         * object keys for a source code .zip file and for a build artifacts .zip file that contains .jar or .class files.
         */
        fun s3RepositoryDetails(s3RepositoryDetails: S3RepositoryDetails): FluentBuilder
        /**
         * The state of the repository association.
         * The valid repository association states are:
         * Associated: The repository
         * association is complete.
         * Associating: CodeGuru Reviewer is:
         * Setting up pull request notifications. This is required
         * for pull requests to trigger a CodeGuru Reviewer review.
         * If your repository ProviderType is GitHub, GitHub Enterprise Server, or Bitbucket,
         * CodeGuru Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you delete these webhooks,
         * reviews of code in your repository cannot be triggered.
         * Setting up source code access. This is required for CodeGuru Reviewer to securely
         * clone code in your repository.
         * Failed: The repository failed to associate or disassociate.
         * Disassociating: CodeGuru Reviewer is removing the repository's pull request notifications and
         * source code access.
         * Disassociated: CodeGuru Reviewer successfully disassociated the repository. You can create a new association
         * with this repository if you want to review source code in it later. You can control access to code reviews created in an
         * associated repository with tags after it has been disassociated. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/auth-and-access-control-using-tags.html">Using tags to control access to
         * associated repositories in the Amazon CodeGuru Reviewer User Guide.
         */
        fun state(state: RepositoryAssociationState): FluentBuilder
        /**
         * A description of why the repository association is in the current state.
         */
        fun stateReason(stateReason: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) identifying the repository association.
         */
        var associationArn: String?
        /**
         * The ID of the repository association.
         */
        var associationId: String?
        /**
         * The Amazon Resource Name (ARN) of an Amazon Web Services CodeStar Connections connection. Its format is
         * arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id. For more information, see
         * <a href="https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html">
         * Connection
         * in
         * the Amazon Web Services CodeStar Connections API Reference.
         */
        var connectionArn: String?
        /**
         * The time, in milliseconds since the epoch, when the repository association was created.
         */
        var createdTimeStamp: Instant?
        /**
         * A KMSKeyDetails object that contains:
         * The encryption option for this repository association. It is either owned by Amazon Web Services
         * Key Management Service (KMS) (AWS_OWNED_CMK) or customer managed (CUSTOMER_MANAGED_CMK).
         * The ID of the Amazon Web Services KMS key that
         * is associated with this respository association.
         */
        var kmsKeyDetails: KmsKeyDetails?
        /**
         * The time, in milliseconds since the epoch, when the repository association was last updated.
         */
        var lastUpdatedTimeStamp: Instant?
        /**
         * The name of the repository.
         */
        var name: String?
        /**
         * The owner of the repository. For an Amazon Web Services CodeCommit repository, this is the Amazon Web Services account ID of the
         * account that owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository, this is the username for the account that owns the repository.
         * For an S3 repository, it can be the username or Amazon Web Services account ID.
         */
        var owner: String?
        /**
         * The provider type of the repository association.
         */
        var providerType: ProviderType?
        /**
         * Specifies the name of an S3 bucket and a CodeArtifacts object that contains the S3
         * object keys for a source code .zip file and for a build artifacts .zip file that contains .jar or .class files.
         */
        var s3RepositoryDetails: S3RepositoryDetails?
        /**
         * The state of the repository association.
         * The valid repository association states are:
         * Associated: The repository
         * association is complete.
         * Associating: CodeGuru Reviewer is:
         * Setting up pull request notifications. This is required
         * for pull requests to trigger a CodeGuru Reviewer review.
         * If your repository ProviderType is GitHub, GitHub Enterprise Server, or Bitbucket,
         * CodeGuru Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you delete these webhooks,
         * reviews of code in your repository cannot be triggered.
         * Setting up source code access. This is required for CodeGuru Reviewer to securely
         * clone code in your repository.
         * Failed: The repository failed to associate or disassociate.
         * Disassociating: CodeGuru Reviewer is removing the repository's pull request notifications and
         * source code access.
         * Disassociated: CodeGuru Reviewer successfully disassociated the repository. You can create a new association
         * with this repository if you want to review source code in it later. You can control access to code reviews created in an
         * associated repository with tags after it has been disassociated. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/auth-and-access-control-using-tags.html">Using tags to control access to
         * associated repositories in the Amazon CodeGuru Reviewer User Guide.
         */
        var state: RepositoryAssociationState?
        /**
         * A description of why the repository association is in the current state.
         */
        var stateReason: String?

        fun build(): RepositoryAssociation
        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.KmsKeyDetails] inside the given [block]
         */
        fun kmsKeyDetails(block: KmsKeyDetails.DslBuilder.() -> kotlin.Unit) {
            this.kmsKeyDetails = KmsKeyDetails.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.S3RepositoryDetails] inside the given [block]
         */
        fun s3RepositoryDetails(block: S3RepositoryDetails.DslBuilder.() -> kotlin.Unit) {
            this.s3RepositoryDetails = S3RepositoryDetails.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var associationArn: String? = null
        override var associationId: String? = null
        override var connectionArn: String? = null
        override var createdTimeStamp: Instant? = null
        override var kmsKeyDetails: KmsKeyDetails? = null
        override var lastUpdatedTimeStamp: Instant? = null
        override var name: String? = null
        override var owner: String? = null
        override var providerType: ProviderType? = null
        override var s3RepositoryDetails: S3RepositoryDetails? = null
        override var state: RepositoryAssociationState? = null
        override var stateReason: String? = null

        constructor(x: RepositoryAssociation) : this() {
            this.associationArn = x.associationArn
            this.associationId = x.associationId
            this.connectionArn = x.connectionArn
            this.createdTimeStamp = x.createdTimeStamp
            this.kmsKeyDetails = x.kmsKeyDetails
            this.lastUpdatedTimeStamp = x.lastUpdatedTimeStamp
            this.name = x.name
            this.owner = x.owner
            this.providerType = x.providerType
            this.s3RepositoryDetails = x.s3RepositoryDetails
            this.state = x.state
            this.stateReason = x.stateReason
        }

        override fun build(): RepositoryAssociation = RepositoryAssociation(this)
        override fun associationArn(associationArn: String): FluentBuilder = apply { this.associationArn = associationArn }
        override fun associationId(associationId: String): FluentBuilder = apply { this.associationId = associationId }
        override fun connectionArn(connectionArn: String): FluentBuilder = apply { this.connectionArn = connectionArn }
        override fun createdTimeStamp(createdTimeStamp: Instant): FluentBuilder = apply { this.createdTimeStamp = createdTimeStamp }
        override fun kmsKeyDetails(kmsKeyDetails: KmsKeyDetails): FluentBuilder = apply { this.kmsKeyDetails = kmsKeyDetails }
        override fun lastUpdatedTimeStamp(lastUpdatedTimeStamp: Instant): FluentBuilder = apply { this.lastUpdatedTimeStamp = lastUpdatedTimeStamp }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun owner(owner: String): FluentBuilder = apply { this.owner = owner }
        override fun providerType(providerType: ProviderType): FluentBuilder = apply { this.providerType = providerType }
        override fun s3RepositoryDetails(s3RepositoryDetails: S3RepositoryDetails): FluentBuilder = apply { this.s3RepositoryDetails = s3RepositoryDetails }
        override fun state(state: RepositoryAssociationState): FluentBuilder = apply { this.state = state }
        override fun stateReason(stateReason: String): FluentBuilder = apply { this.stateReason = stateReason }
    }
}
