// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summary information about a repository association. The
 * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
 * ListRepositoryAssociations
 * operation returns a list of RepositoryAssociationSummary objects.
 */
class RepositoryAssociationSummary private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the
     * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
     * RepositoryAssociation
     * object.
     * You can retrieve this ARN by calling
     * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
     * ListRepositoryAssociations
     * .
     */
    val associationArn: String? = builder.associationArn
    /**
     * The repository association ID.
     */
    val associationId: String? = builder.associationId
    /**
     * The Amazon Resource Name (ARN) of an Amazon Web Services CodeStar Connections connection. Its format is
     * arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id. For more information, see
     * <a href="https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html">
     * Connection
     * in
     * the Amazon Web Services CodeStar Connections API Reference.
     */
    val connectionArn: String? = builder.connectionArn
    /**
     * The time, in milliseconds since the epoch, since the repository association
     * was last updated.
     */
    val lastUpdatedTimeStamp: Instant? = builder.lastUpdatedTimeStamp
    /**
     * The name of the repository association.
     */
    val name: String? = builder.name
    /**
     * The owner of the repository. For an Amazon Web Services CodeCommit repository, this is the Amazon Web Services account ID of the
     * account that owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository, this is the username for the account that owns the repository.
     * For an S3 repository, it can be the username or Amazon Web Services account ID.
     */
    val owner: String? = builder.owner
    /**
     * The provider type of the repository association.
     */
    val providerType: ProviderType? = builder.providerType
    /**
     * The state of the repository association.
     * The valid repository association states are:
     * Associated: The repository
     * association is complete.
     * Associating: CodeGuru Reviewer is:
     * Setting up pull request notifications. This is required
     * for pull requests to trigger a CodeGuru Reviewer review.
     * If your repository ProviderType is GitHub, GitHub Enterprise Server, or Bitbucket,
     * CodeGuru Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you delete these webhooks,
     * reviews of code in your repository cannot be triggered.
     * Setting up source code access. This is required for CodeGuru Reviewer to securely
     * clone code in your repository.
     * Failed: The repository failed to associate or disassociate.
     * Disassociating: CodeGuru Reviewer is removing the repository's pull request notifications and
     * source code access.
     * Disassociated: CodeGuru Reviewer successfully disassociated the repository. You can create a new association
     * with this repository if you want to review source code in it later. You can control access to code reviews created in an
     * associated repository with tags after it has been disassociated. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/auth-and-access-control-using-tags.html">Using tags to control access to
     * associated repositories in the Amazon CodeGuru Reviewer User Guide.
     */
    val state: RepositoryAssociationState? = builder.state

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RepositoryAssociationSummary = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RepositoryAssociationSummary(")
        append("associationArn=$associationArn,")
        append("associationId=$associationId,")
        append("connectionArn=$connectionArn,")
        append("lastUpdatedTimeStamp=$lastUpdatedTimeStamp,")
        append("name=$name,")
        append("owner=$owner,")
        append("providerType=$providerType,")
        append("state=$state)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associationArn?.hashCode() ?: 0
        result = 31 * result + (associationId?.hashCode() ?: 0)
        result = 31 * result + (connectionArn?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTimeStamp?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (providerType?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RepositoryAssociationSummary

        if (associationArn != other.associationArn) return false
        if (associationId != other.associationId) return false
        if (connectionArn != other.connectionArn) return false
        if (lastUpdatedTimeStamp != other.lastUpdatedTimeStamp) return false
        if (name != other.name) return false
        if (owner != other.owner) return false
        if (providerType != other.providerType) return false
        if (state != other.state) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RepositoryAssociationSummary = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RepositoryAssociationSummary
        /**
         * The Amazon Resource Name (ARN) of the
         * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
         * RepositoryAssociation
         * object.
         * You can retrieve this ARN by calling
         * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
         * ListRepositoryAssociations
         * .
         */
        fun associationArn(associationArn: String): FluentBuilder
        /**
         * The repository association ID.
         */
        fun associationId(associationId: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of an Amazon Web Services CodeStar Connections connection. Its format is
         * arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id. For more information, see
         * <a href="https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html">
         * Connection
         * in
         * the Amazon Web Services CodeStar Connections API Reference.
         */
        fun connectionArn(connectionArn: String): FluentBuilder
        /**
         * The time, in milliseconds since the epoch, since the repository association
         * was last updated.
         */
        fun lastUpdatedTimeStamp(lastUpdatedTimeStamp: Instant): FluentBuilder
        /**
         * The name of the repository association.
         */
        fun name(name: String): FluentBuilder
        /**
         * The owner of the repository. For an Amazon Web Services CodeCommit repository, this is the Amazon Web Services account ID of the
         * account that owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository, this is the username for the account that owns the repository.
         * For an S3 repository, it can be the username or Amazon Web Services account ID.
         */
        fun owner(owner: String): FluentBuilder
        /**
         * The provider type of the repository association.
         */
        fun providerType(providerType: ProviderType): FluentBuilder
        /**
         * The state of the repository association.
         * The valid repository association states are:
         * Associated: The repository
         * association is complete.
         * Associating: CodeGuru Reviewer is:
         * Setting up pull request notifications. This is required
         * for pull requests to trigger a CodeGuru Reviewer review.
         * If your repository ProviderType is GitHub, GitHub Enterprise Server, or Bitbucket,
         * CodeGuru Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you delete these webhooks,
         * reviews of code in your repository cannot be triggered.
         * Setting up source code access. This is required for CodeGuru Reviewer to securely
         * clone code in your repository.
         * Failed: The repository failed to associate or disassociate.
         * Disassociating: CodeGuru Reviewer is removing the repository's pull request notifications and
         * source code access.
         * Disassociated: CodeGuru Reviewer successfully disassociated the repository. You can create a new association
         * with this repository if you want to review source code in it later. You can control access to code reviews created in an
         * associated repository with tags after it has been disassociated. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/auth-and-access-control-using-tags.html">Using tags to control access to
         * associated repositories in the Amazon CodeGuru Reviewer User Guide.
         */
        fun state(state: RepositoryAssociationState): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the
         * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
         * RepositoryAssociation
         * object.
         * You can retrieve this ARN by calling
         * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
         * ListRepositoryAssociations
         * .
         */
        var associationArn: String?
        /**
         * The repository association ID.
         */
        var associationId: String?
        /**
         * The Amazon Resource Name (ARN) of an Amazon Web Services CodeStar Connections connection. Its format is
         * arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id. For more information, see
         * <a href="https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html">
         * Connection
         * in
         * the Amazon Web Services CodeStar Connections API Reference.
         */
        var connectionArn: String?
        /**
         * The time, in milliseconds since the epoch, since the repository association
         * was last updated.
         */
        var lastUpdatedTimeStamp: Instant?
        /**
         * The name of the repository association.
         */
        var name: String?
        /**
         * The owner of the repository. For an Amazon Web Services CodeCommit repository, this is the Amazon Web Services account ID of the
         * account that owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository, this is the username for the account that owns the repository.
         * For an S3 repository, it can be the username or Amazon Web Services account ID.
         */
        var owner: String?
        /**
         * The provider type of the repository association.
         */
        var providerType: ProviderType?
        /**
         * The state of the repository association.
         * The valid repository association states are:
         * Associated: The repository
         * association is complete.
         * Associating: CodeGuru Reviewer is:
         * Setting up pull request notifications. This is required
         * for pull requests to trigger a CodeGuru Reviewer review.
         * If your repository ProviderType is GitHub, GitHub Enterprise Server, or Bitbucket,
         * CodeGuru Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you delete these webhooks,
         * reviews of code in your repository cannot be triggered.
         * Setting up source code access. This is required for CodeGuru Reviewer to securely
         * clone code in your repository.
         * Failed: The repository failed to associate or disassociate.
         * Disassociating: CodeGuru Reviewer is removing the repository's pull request notifications and
         * source code access.
         * Disassociated: CodeGuru Reviewer successfully disassociated the repository. You can create a new association
         * with this repository if you want to review source code in it later. You can control access to code reviews created in an
         * associated repository with tags after it has been disassociated. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/auth-and-access-control-using-tags.html">Using tags to control access to
         * associated repositories in the Amazon CodeGuru Reviewer User Guide.
         */
        var state: RepositoryAssociationState?

        fun build(): RepositoryAssociationSummary
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var associationArn: String? = null
        override var associationId: String? = null
        override var connectionArn: String? = null
        override var lastUpdatedTimeStamp: Instant? = null
        override var name: String? = null
        override var owner: String? = null
        override var providerType: ProviderType? = null
        override var state: RepositoryAssociationState? = null

        constructor(x: RepositoryAssociationSummary) : this() {
            this.associationArn = x.associationArn
            this.associationId = x.associationId
            this.connectionArn = x.connectionArn
            this.lastUpdatedTimeStamp = x.lastUpdatedTimeStamp
            this.name = x.name
            this.owner = x.owner
            this.providerType = x.providerType
            this.state = x.state
        }

        override fun build(): RepositoryAssociationSummary = RepositoryAssociationSummary(this)
        override fun associationArn(associationArn: String): FluentBuilder = apply { this.associationArn = associationArn }
        override fun associationId(associationId: String): FluentBuilder = apply { this.associationId = associationId }
        override fun connectionArn(connectionArn: String): FluentBuilder = apply { this.connectionArn = connectionArn }
        override fun lastUpdatedTimeStamp(lastUpdatedTimeStamp: Instant): FluentBuilder = apply { this.lastUpdatedTimeStamp = lastUpdatedTimeStamp }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun owner(owner: String): FluentBuilder = apply { this.owner = owner }
        override fun providerType(providerType: ProviderType): FluentBuilder = apply { this.providerType = providerType }
        override fun state(state: RepositoryAssociationState): FluentBuilder = apply { this.state = state }
    }
}
