// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model



/**
 * Metadata that is associated with a code review. This applies to both pull request
 * and repository analysis code reviews.
 */
class RequestMetadata private constructor(builder: BuilderImpl) {
    /**
     * Information about the event associated with a code review.
     */
    val eventInfo: EventInfo? = builder.eventInfo
    /**
     * The ID of the request. This is required for a pull request code review.
     */
    val requestId: String? = builder.requestId
    /**
     * An identifier, such as a name or account ID, that is associated with the requester. The
     * Requester is used to capture the author/actor name of the event request.
     */
    val requester: String? = builder.requester
    /**
     * The name of the repository vendor used to upload code to an S3 bucket for a CI/CD code
     * review. For example, if code and artifacts are uploaded to an S3 bucket for a CI/CD code
     * review by GitHub scripts from a GitHub repository, then the repository association's ProviderType is
     * S3Bucket and the CI/CD repository vendor name is GitHub. For more
     * information, see the definition for ProviderType in <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">RepositoryAssociation.
     */
    val vendorName: VendorName? = builder.vendorName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RequestMetadata = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RequestMetadata(")
        append("eventInfo=$eventInfo,")
        append("requestId=$requestId,")
        append("requester=$requester,")
        append("vendorName=$vendorName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = eventInfo?.hashCode() ?: 0
        result = 31 * result + (requestId?.hashCode() ?: 0)
        result = 31 * result + (requester?.hashCode() ?: 0)
        result = 31 * result + (vendorName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RequestMetadata

        if (eventInfo != other.eventInfo) return false
        if (requestId != other.requestId) return false
        if (requester != other.requester) return false
        if (vendorName != other.vendorName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RequestMetadata = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RequestMetadata
        /**
         * Information about the event associated with a code review.
         */
        fun eventInfo(eventInfo: EventInfo): FluentBuilder
        /**
         * The ID of the request. This is required for a pull request code review.
         */
        fun requestId(requestId: String): FluentBuilder
        /**
         * An identifier, such as a name or account ID, that is associated with the requester. The
         * Requester is used to capture the author/actor name of the event request.
         */
        fun requester(requester: String): FluentBuilder
        /**
         * The name of the repository vendor used to upload code to an S3 bucket for a CI/CD code
         * review. For example, if code and artifacts are uploaded to an S3 bucket for a CI/CD code
         * review by GitHub scripts from a GitHub repository, then the repository association's ProviderType is
         * S3Bucket and the CI/CD repository vendor name is GitHub. For more
         * information, see the definition for ProviderType in <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">RepositoryAssociation.
         */
        fun vendorName(vendorName: VendorName): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Information about the event associated with a code review.
         */
        var eventInfo: EventInfo?
        /**
         * The ID of the request. This is required for a pull request code review.
         */
        var requestId: String?
        /**
         * An identifier, such as a name or account ID, that is associated with the requester. The
         * Requester is used to capture the author/actor name of the event request.
         */
        var requester: String?
        /**
         * The name of the repository vendor used to upload code to an S3 bucket for a CI/CD code
         * review. For example, if code and artifacts are uploaded to an S3 bucket for a CI/CD code
         * review by GitHub scripts from a GitHub repository, then the repository association's ProviderType is
         * S3Bucket and the CI/CD repository vendor name is GitHub. For more
         * information, see the definition for ProviderType in <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">RepositoryAssociation.
         */
        var vendorName: VendorName?

        fun build(): RequestMetadata
        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.EventInfo] inside the given [block]
         */
        fun eventInfo(block: EventInfo.DslBuilder.() -> kotlin.Unit) {
            this.eventInfo = EventInfo.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var eventInfo: EventInfo? = null
        override var requestId: String? = null
        override var requester: String? = null
        override var vendorName: VendorName? = null

        constructor(x: RequestMetadata) : this() {
            this.eventInfo = x.eventInfo
            this.requestId = x.requestId
            this.requester = x.requester
            this.vendorName = x.vendorName
        }

        override fun build(): RequestMetadata = RequestMetadata(this)
        override fun eventInfo(eventInfo: EventInfo): FluentBuilder = apply { this.eventInfo = eventInfo }
        override fun requestId(requestId: String): FluentBuilder = apply { this.requestId = requestId }
        override fun requester(requester: String): FluentBuilder = apply { this.requester = requester }
        override fun vendorName(vendorName: VendorName): FluentBuilder = apply { this.vendorName = vendorName }
    }
}
