// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model



/**
 * Metadata about a rule. Rule metadata includes an ID, a name, a list of tags, and a
 * short and long description. CodeGuru Reviewer uses rules to analyze code. A rule's recommendation is
 * included in analysis results if code is detected that violates the rule.
 */
class RuleMetadata private constructor(builder: BuilderImpl) {
    /**
     * A long description of the rule.
     */
    val longDescription: String? = builder.longDescription
    /**
     * The ID of the rule.
     */
    val ruleId: String? = builder.ruleId
    /**
     * The name of the rule.
     */
    val ruleName: String? = builder.ruleName
    /**
     * Tags that are associated with the rule.
     */
    val ruleTags: List<String>? = builder.ruleTags
    /**
     * A short description of the rule.
     */
    val shortDescription: String? = builder.shortDescription

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RuleMetadata = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RuleMetadata(")
        append("longDescription=$longDescription,")
        append("ruleId=$ruleId,")
        append("ruleName=$ruleName,")
        append("ruleTags=$ruleTags,")
        append("shortDescription=$shortDescription)")
    }

    override fun hashCode(): kotlin.Int {
        var result = longDescription?.hashCode() ?: 0
        result = 31 * result + (ruleId?.hashCode() ?: 0)
        result = 31 * result + (ruleName?.hashCode() ?: 0)
        result = 31 * result + (ruleTags?.hashCode() ?: 0)
        result = 31 * result + (shortDescription?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RuleMetadata

        if (longDescription != other.longDescription) return false
        if (ruleId != other.ruleId) return false
        if (ruleName != other.ruleName) return false
        if (ruleTags != other.ruleTags) return false
        if (shortDescription != other.shortDescription) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RuleMetadata = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RuleMetadata
        /**
         * A long description of the rule.
         */
        fun longDescription(longDescription: String): FluentBuilder
        /**
         * The ID of the rule.
         */
        fun ruleId(ruleId: String): FluentBuilder
        /**
         * The name of the rule.
         */
        fun ruleName(ruleName: String): FluentBuilder
        /**
         * Tags that are associated with the rule.
         */
        fun ruleTags(ruleTags: List<String>): FluentBuilder
        /**
         * A short description of the rule.
         */
        fun shortDescription(shortDescription: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A long description of the rule.
         */
        var longDescription: String?
        /**
         * The ID of the rule.
         */
        var ruleId: String?
        /**
         * The name of the rule.
         */
        var ruleName: String?
        /**
         * Tags that are associated with the rule.
         */
        var ruleTags: List<String>?
        /**
         * A short description of the rule.
         */
        var shortDescription: String?

        fun build(): RuleMetadata
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var longDescription: String? = null
        override var ruleId: String? = null
        override var ruleName: String? = null
        override var ruleTags: List<String>? = null
        override var shortDescription: String? = null

        constructor(x: RuleMetadata) : this() {
            this.longDescription = x.longDescription
            this.ruleId = x.ruleId
            this.ruleName = x.ruleName
            this.ruleTags = x.ruleTags
            this.shortDescription = x.shortDescription
        }

        override fun build(): RuleMetadata = RuleMetadata(this)
        override fun longDescription(longDescription: String): FluentBuilder = apply { this.longDescription = longDescription }
        override fun ruleId(ruleId: String): FluentBuilder = apply { this.ruleId = ruleId }
        override fun ruleName(ruleName: String): FluentBuilder = apply { this.ruleName = ruleName }
        override fun ruleTags(ruleTags: List<String>): FluentBuilder = apply { this.ruleTags = ruleTags }
        override fun shortDescription(shortDescription: String): FluentBuilder = apply { this.shortDescription = shortDescription }
    }
}
