// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model



/**
 * Information about an associated repository in an S3 bucket. The associated repository contains a source code
 * .zip file and a build artifacts .zip file that contains .jar or .class files.
 */
class S3BucketRepository private constructor(builder: BuilderImpl) {
    /**
     * An S3RepositoryDetails object that specifies the name of an S3 bucket and
     * a CodeArtifacts object. The CodeArtifacts object includes the S3
     * object keys for a source code .zip file and for a build artifacts .zip file.
     */
    val details: S3RepositoryDetails? = builder.details
    /**
     * The name of the repository when the ProviderType is S3Bucket.
     */
    val name: String? = builder.name

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): S3BucketRepository = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("S3BucketRepository(")
        append("details=$details,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = details?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as S3BucketRepository

        if (details != other.details) return false
        if (name != other.name) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): S3BucketRepository = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): S3BucketRepository
        /**
         * An S3RepositoryDetails object that specifies the name of an S3 bucket and
         * a CodeArtifacts object. The CodeArtifacts object includes the S3
         * object keys for a source code .zip file and for a build artifacts .zip file.
         */
        fun details(details: S3RepositoryDetails): FluentBuilder
        /**
         * The name of the repository when the ProviderType is S3Bucket.
         */
        fun name(name: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * An S3RepositoryDetails object that specifies the name of an S3 bucket and
         * a CodeArtifacts object. The CodeArtifacts object includes the S3
         * object keys for a source code .zip file and for a build artifacts .zip file.
         */
        var details: S3RepositoryDetails?
        /**
         * The name of the repository when the ProviderType is S3Bucket.
         */
        var name: String?

        fun build(): S3BucketRepository
        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.S3RepositoryDetails] inside the given [block]
         */
        fun details(block: S3RepositoryDetails.DslBuilder.() -> kotlin.Unit) {
            this.details = S3RepositoryDetails.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var details: S3RepositoryDetails? = null
        override var name: String? = null

        constructor(x: S3BucketRepository) : this() {
            this.details = x.details
            this.name = x.name
        }

        override fun build(): S3BucketRepository = S3BucketRepository(this)
        override fun details(details: S3RepositoryDetails): FluentBuilder = apply { this.details = details }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
    }
}
