// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model



/**
 * Specifies the name of an S3 bucket and a CodeArtifacts object that contains the S3
 * object keys for a source code .zip file and for a build artifacts .zip file that contains .jar or .class files.
 */
class S3RepositoryDetails private constructor(builder: BuilderImpl) {
    /**
     * The name of the S3 bucket used for associating a new S3 repository. It must begin with
     * codeguru-reviewer-.
     */
    val bucketName: String? = builder.bucketName
    /**
     * A CodeArtifacts object. The CodeArtifacts object includes the S3
     * object key for a source code .zip file and for a build artifacts .zip file that contains .jar or .class files.
     */
    val codeArtifacts: CodeArtifacts? = builder.codeArtifacts

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): S3RepositoryDetails = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("S3RepositoryDetails(")
        append("bucketName=$bucketName,")
        append("codeArtifacts=$codeArtifacts)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketName?.hashCode() ?: 0
        result = 31 * result + (codeArtifacts?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as S3RepositoryDetails

        if (bucketName != other.bucketName) return false
        if (codeArtifacts != other.codeArtifacts) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): S3RepositoryDetails = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): S3RepositoryDetails
        /**
         * The name of the S3 bucket used for associating a new S3 repository. It must begin with
         * codeguru-reviewer-.
         */
        fun bucketName(bucketName: String): FluentBuilder
        /**
         * A CodeArtifacts object. The CodeArtifacts object includes the S3
         * object key for a source code .zip file and for a build artifacts .zip file that contains .jar or .class files.
         */
        fun codeArtifacts(codeArtifacts: CodeArtifacts): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the S3 bucket used for associating a new S3 repository. It must begin with
         * codeguru-reviewer-.
         */
        var bucketName: String?
        /**
         * A CodeArtifacts object. The CodeArtifacts object includes the S3
         * object key for a source code .zip file and for a build artifacts .zip file that contains .jar or .class files.
         */
        var codeArtifacts: CodeArtifacts?

        fun build(): S3RepositoryDetails
        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.CodeArtifacts] inside the given [block]
         */
        fun codeArtifacts(block: CodeArtifacts.DslBuilder.() -> kotlin.Unit) {
            this.codeArtifacts = CodeArtifacts.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var bucketName: String? = null
        override var codeArtifacts: CodeArtifacts? = null

        constructor(x: S3RepositoryDetails) : this() {
            this.bucketName = x.bucketName
            this.codeArtifacts = x.codeArtifacts
        }

        override fun build(): S3RepositoryDetails = S3RepositoryDetails(this)
        override fun bucketName(bucketName: String): FluentBuilder = apply { this.bucketName = bucketName }
        override fun codeArtifacts(codeArtifacts: CodeArtifacts): FluentBuilder = apply { this.codeArtifacts = codeArtifacts }
    }
}
