// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model



/**
 * Specifies the source code that is analyzed in a code review.
 */
class SourceCodeType private constructor(builder: BuilderImpl) {
    /**
     * A type of <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
     * SourceCodeType
     * that
     * specifies a source branch name and a destination branch name in an associated repository.
     */
    val branchDiff: BranchDiffSourceCodeType? = builder.branchDiff
    /**
     * A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
     * SourceCodeType
     * that
     * specifies a commit diff created by a pull request on an associated repository.
     */
    val commitDiff: CommitDiffSourceCodeType? = builder.commitDiff
    /**
     * A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
     * SourceCodeType
     * that specifies
     * the tip of a branch in an associated repository.
     */
    val repositoryHead: RepositoryHeadSourceCodeType? = builder.repositoryHead
    /**
     * Metadata that is associated with a code review. This applies to any type of code review supported by CodeGuru Reviewer. The
     * RequestMetadaa field captures any event metadata. For example, it might capture metadata associated with
     * an event trigger, such as a push or a pull request.
     */
    val requestMetadata: RequestMetadata? = builder.requestMetadata
    /**
     * Information about an associated repository in an S3 bucket that includes its name and an S3RepositoryDetails object.
     * The S3RepositoryDetails object includes the name of an S3 bucket, an S3 key for a source code .zip file, and
     * an S3 key for a build artifacts .zip file. S3BucketRepository is required in <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
     * SourceCodeType
     * for
     * S3BucketRepository based code reviews.
     */
    val s3BucketRepository: S3BucketRepository? = builder.s3BucketRepository

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SourceCodeType = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SourceCodeType(")
        append("branchDiff=$branchDiff,")
        append("commitDiff=$commitDiff,")
        append("repositoryHead=$repositoryHead,")
        append("requestMetadata=$requestMetadata,")
        append("s3BucketRepository=$s3BucketRepository)")
    }

    override fun hashCode(): kotlin.Int {
        var result = branchDiff?.hashCode() ?: 0
        result = 31 * result + (commitDiff?.hashCode() ?: 0)
        result = 31 * result + (repositoryHead?.hashCode() ?: 0)
        result = 31 * result + (requestMetadata?.hashCode() ?: 0)
        result = 31 * result + (s3BucketRepository?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SourceCodeType

        if (branchDiff != other.branchDiff) return false
        if (commitDiff != other.commitDiff) return false
        if (repositoryHead != other.repositoryHead) return false
        if (requestMetadata != other.requestMetadata) return false
        if (s3BucketRepository != other.s3BucketRepository) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SourceCodeType = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SourceCodeType
        /**
         * A type of <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
         * SourceCodeType
         * that
         * specifies a source branch name and a destination branch name in an associated repository.
         */
        fun branchDiff(branchDiff: BranchDiffSourceCodeType): FluentBuilder
        /**
         * A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
         * SourceCodeType
         * that
         * specifies a commit diff created by a pull request on an associated repository.
         */
        fun commitDiff(commitDiff: CommitDiffSourceCodeType): FluentBuilder
        /**
         * A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
         * SourceCodeType
         * that specifies
         * the tip of a branch in an associated repository.
         */
        fun repositoryHead(repositoryHead: RepositoryHeadSourceCodeType): FluentBuilder
        /**
         * Metadata that is associated with a code review. This applies to any type of code review supported by CodeGuru Reviewer. The
         * RequestMetadaa field captures any event metadata. For example, it might capture metadata associated with
         * an event trigger, such as a push or a pull request.
         */
        fun requestMetadata(requestMetadata: RequestMetadata): FluentBuilder
        /**
         * Information about an associated repository in an S3 bucket that includes its name and an S3RepositoryDetails object.
         * The S3RepositoryDetails object includes the name of an S3 bucket, an S3 key for a source code .zip file, and
         * an S3 key for a build artifacts .zip file. S3BucketRepository is required in <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
         * SourceCodeType
         * for
         * S3BucketRepository based code reviews.
         */
        fun s3BucketRepository(s3BucketRepository: S3BucketRepository): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A type of <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
         * SourceCodeType
         * that
         * specifies a source branch name and a destination branch name in an associated repository.
         */
        var branchDiff: BranchDiffSourceCodeType?
        /**
         * A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
         * SourceCodeType
         * that
         * specifies a commit diff created by a pull request on an associated repository.
         */
        var commitDiff: CommitDiffSourceCodeType?
        /**
         * A <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
         * SourceCodeType
         * that specifies
         * the tip of a branch in an associated repository.
         */
        var repositoryHead: RepositoryHeadSourceCodeType?
        /**
         * Metadata that is associated with a code review. This applies to any type of code review supported by CodeGuru Reviewer. The
         * RequestMetadaa field captures any event metadata. For example, it might capture metadata associated with
         * an event trigger, such as a push or a pull request.
         */
        var requestMetadata: RequestMetadata?
        /**
         * Information about an associated repository in an S3 bucket that includes its name and an S3RepositoryDetails object.
         * The S3RepositoryDetails object includes the name of an S3 bucket, an S3 key for a source code .zip file, and
         * an S3 key for a build artifacts .zip file. S3BucketRepository is required in <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType">
         * SourceCodeType
         * for
         * S3BucketRepository based code reviews.
         */
        var s3BucketRepository: S3BucketRepository?

        fun build(): SourceCodeType
        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.BranchDiffSourceCodeType] inside the given [block]
         */
        fun branchDiff(block: BranchDiffSourceCodeType.DslBuilder.() -> kotlin.Unit) {
            this.branchDiff = BranchDiffSourceCodeType.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.CommitDiffSourceCodeType] inside the given [block]
         */
        fun commitDiff(block: CommitDiffSourceCodeType.DslBuilder.() -> kotlin.Unit) {
            this.commitDiff = CommitDiffSourceCodeType.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.RepositoryHeadSourceCodeType] inside the given [block]
         */
        fun repositoryHead(block: RepositoryHeadSourceCodeType.DslBuilder.() -> kotlin.Unit) {
            this.repositoryHead = RepositoryHeadSourceCodeType.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.RequestMetadata] inside the given [block]
         */
        fun requestMetadata(block: RequestMetadata.DslBuilder.() -> kotlin.Unit) {
            this.requestMetadata = RequestMetadata.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.S3BucketRepository] inside the given [block]
         */
        fun s3BucketRepository(block: S3BucketRepository.DslBuilder.() -> kotlin.Unit) {
            this.s3BucketRepository = S3BucketRepository.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var branchDiff: BranchDiffSourceCodeType? = null
        override var commitDiff: CommitDiffSourceCodeType? = null
        override var repositoryHead: RepositoryHeadSourceCodeType? = null
        override var requestMetadata: RequestMetadata? = null
        override var s3BucketRepository: S3BucketRepository? = null

        constructor(x: SourceCodeType) : this() {
            this.branchDiff = x.branchDiff
            this.commitDiff = x.commitDiff
            this.repositoryHead = x.repositoryHead
            this.requestMetadata = x.requestMetadata
            this.s3BucketRepository = x.s3BucketRepository
        }

        override fun build(): SourceCodeType = SourceCodeType(this)
        override fun branchDiff(branchDiff: BranchDiffSourceCodeType): FluentBuilder = apply { this.branchDiff = branchDiff }
        override fun commitDiff(commitDiff: CommitDiffSourceCodeType): FluentBuilder = apply { this.commitDiff = commitDiff }
        override fun repositoryHead(repositoryHead: RepositoryHeadSourceCodeType): FluentBuilder = apply { this.repositoryHead = repositoryHead }
        override fun requestMetadata(requestMetadata: RequestMetadata): FluentBuilder = apply { this.requestMetadata = requestMetadata }
        override fun s3BucketRepository(s3BucketRepository: S3BucketRepository): FluentBuilder = apply { this.s3BucketRepository = s3BucketRepository }
    }
}
