// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model



class TagResourceRequest private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the
     * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
     * RepositoryAssociation
     * object.
     * You can retrieve this ARN by calling
     * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
     * ListRepositoryAssociations
     * .
     */
    val resourceArn: String? = builder.resourceArn
    /**
     * An array of key-value pairs used to tag an associated repository. A tag is a custom attribute label with two parts:
     * A tag key (for example, CostCenter,
     * Environment, Project, or Secret). Tag
     * keys are case sensitive.
     * An optional field known as a tag value (for example,
     * 111122223333, Production, or a team name).
     * Omitting the tag value is the same as using an empty string. Like tag keys, tag
     * values are case sensitive.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TagResourceRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TagResourceRequest(")
        append("resourceArn=$resourceArn,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceArn?.hashCode() ?: 0
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TagResourceRequest

        if (resourceArn != other.resourceArn) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TagResourceRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TagResourceRequest
        /**
         * The Amazon Resource Name (ARN) of the
         * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
         * RepositoryAssociation
         * object.
         * You can retrieve this ARN by calling
         * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
         * ListRepositoryAssociations
         * .
         */
        fun resourceArn(resourceArn: String): FluentBuilder
        /**
         * An array of key-value pairs used to tag an associated repository. A tag is a custom attribute label with two parts:
         * A tag key (for example, CostCenter,
         * Environment, Project, or Secret). Tag
         * keys are case sensitive.
         * An optional field known as a tag value (for example,
         * 111122223333, Production, or a team name).
         * Omitting the tag value is the same as using an empty string. Like tag keys, tag
         * values are case sensitive.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the
         * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html">
         * RepositoryAssociation
         * object.
         * You can retrieve this ARN by calling
         * <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html">
         * ListRepositoryAssociations
         * .
         */
        var resourceArn: String?
        /**
         * An array of key-value pairs used to tag an associated repository. A tag is a custom attribute label with two parts:
         * A tag key (for example, CostCenter,
         * Environment, Project, or Secret). Tag
         * keys are case sensitive.
         * An optional field known as a tag value (for example,
         * 111122223333, Production, or a team name).
         * Omitting the tag value is the same as using an empty string. Like tag keys, tag
         * values are case sensitive.
         */
        var tags: Map<String, String>?

        fun build(): TagResourceRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var resourceArn: String? = null
        override var tags: Map<String, String>? = null

        constructor(x: TagResourceRequest) : this() {
            this.resourceArn = x.resourceArn
            this.tags = x.tags
        }

        override fun build(): TagResourceRequest = TagResourceRequest(this)
        override fun resourceArn(resourceArn: String): FluentBuilder = apply { this.resourceArn = resourceArn }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
