// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model



/**
 * Information about a third-party source repository connected to CodeGuru Reviewer.
 */
class ThirdPartySourceRepository private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of an Amazon Web Services CodeStar Connections connection. Its format is
     * arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id. For more information, see
     * <a href="https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html">
     * Connection
     * in
     * the Amazon Web Services CodeStar Connections API Reference.
     */
    val connectionArn: String? = builder.connectionArn
    /**
     * The name of the third party source repository.
     */
    val name: String? = builder.name
    /**
     * The owner of the repository. For a GitHub, GitHub Enterprise, or Bitbucket repository,
     * this is the username for the account that owns the repository. For an S3 repository,
     * this can be the username or Amazon Web Services account ID.
     */
    val owner: String? = builder.owner

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ThirdPartySourceRepository = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ThirdPartySourceRepository(")
        append("connectionArn=$connectionArn,")
        append("name=$name,")
        append("owner=$owner)")
    }

    override fun hashCode(): kotlin.Int {
        var result = connectionArn?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ThirdPartySourceRepository

        if (connectionArn != other.connectionArn) return false
        if (name != other.name) return false
        if (owner != other.owner) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ThirdPartySourceRepository = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ThirdPartySourceRepository
        /**
         * The Amazon Resource Name (ARN) of an Amazon Web Services CodeStar Connections connection. Its format is
         * arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id. For more information, see
         * <a href="https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html">
         * Connection
         * in
         * the Amazon Web Services CodeStar Connections API Reference.
         */
        fun connectionArn(connectionArn: String): FluentBuilder
        /**
         * The name of the third party source repository.
         */
        fun name(name: String): FluentBuilder
        /**
         * The owner of the repository. For a GitHub, GitHub Enterprise, or Bitbucket repository,
         * this is the username for the account that owns the repository. For an S3 repository,
         * this can be the username or Amazon Web Services account ID.
         */
        fun owner(owner: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of an Amazon Web Services CodeStar Connections connection. Its format is
         * arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id. For more information, see
         * <a href="https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html">
         * Connection
         * in
         * the Amazon Web Services CodeStar Connections API Reference.
         */
        var connectionArn: String?
        /**
         * The name of the third party source repository.
         */
        var name: String?
        /**
         * The owner of the repository. For a GitHub, GitHub Enterprise, or Bitbucket repository,
         * this is the username for the account that owns the repository. For an S3 repository,
         * this can be the username or Amazon Web Services account ID.
         */
        var owner: String?

        fun build(): ThirdPartySourceRepository
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var connectionArn: String? = null
        override var name: String? = null
        override var owner: String? = null

        constructor(x: ThirdPartySourceRepository) : this() {
            this.connectionArn = x.connectionArn
            this.name = x.name
            this.owner = x.owner
        }

        override fun build(): ThirdPartySourceRepository = ThirdPartySourceRepository(this)
        override fun connectionArn(connectionArn: String): FluentBuilder = apply { this.connectionArn = connectionArn }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun owner(owner: String): FluentBuilder = apply { this.owner = owner }
    }
}
