// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codegurureviewer.model.CodeGuruReviewerException
import aws.sdk.kotlin.services.codegurureviewer.model.ListRecommendationsResponse
import aws.sdk.kotlin.services.codegurureviewer.model.RecommendationSummary
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListRecommendationsOperationDeserializer: HttpDeserialize<ListRecommendationsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListRecommendationsResponse {
        if (!response.status.isSuccess()) {
            throwListRecommendationsError(context, response)
        }
        val builder = ListRecommendationsResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListRecommendationsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeListRecommendationsOperationBody(builder: ListRecommendationsResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val RECOMMENDATIONSUMMARIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("RecommendationSummaries"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(RECOMMENDATIONSUMMARIES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                RECOMMENDATIONSUMMARIES_DESCRIPTOR.index -> builder.recommendationSummaries =
                    deserializer.deserializeList(RECOMMENDATIONSUMMARIES_DESCRIPTOR) {
                        val col0 = mutableListOf<RecommendationSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeRecommendationSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwListRecommendationsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer()
        "InternalServerException" -> InternalServerExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        "ValidationException" -> ValidationExceptionDeserializer()
        else -> throw CodeGuruReviewerException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
