// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Returns information about an execution of an action, including the action execution ID, and the name, version, and timing of the action.
 */
public class ActionExecutionDetail private constructor(builder: Builder) {
    /**
     * The action execution ID.
     */
    public val actionExecutionId: kotlin.String? = builder.actionExecutionId
    /**
     * The name of the action.
     */
    public val actionName: kotlin.String? = builder.actionName
    /**
     * Input details for the action execution, such as role ARN, Region, and input artifacts.
     */
    public val input: aws.sdk.kotlin.services.codepipeline.model.ActionExecutionInput? = builder.input
    /**
     * The last update time of the action execution.
     */
    public val lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdateTime
    /**
     * Output details for the action execution, such as the action execution result.
     */
    public val output: aws.sdk.kotlin.services.codepipeline.model.ActionExecutionOutput? = builder.output
    /**
     * The pipeline execution ID for the action execution.
     */
    public val pipelineExecutionId: kotlin.String? = builder.pipelineExecutionId
    /**
     * The version of the pipeline where the action was run.
     */
    public val pipelineVersion: kotlin.Int? = builder.pipelineVersion
    /**
     * The name of the stage that contains the action.
     */
    public val stageName: kotlin.String? = builder.stageName
    /**
     * The start time of the action execution.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The status of the action execution. Status categories are `InProgress`, `Succeeded`, and `Failed`.
     */
    public val status: aws.sdk.kotlin.services.codepipeline.model.ActionExecutionStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codepipeline.model.ActionExecutionDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ActionExecutionDetail(")
        append("actionExecutionId=$actionExecutionId,")
        append("actionName=$actionName,")
        append("input=$input,")
        append("lastUpdateTime=$lastUpdateTime,")
        append("output=$output,")
        append("pipelineExecutionId=$pipelineExecutionId,")
        append("pipelineVersion=$pipelineVersion,")
        append("stageName=$stageName,")
        append("startTime=$startTime,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionExecutionId?.hashCode() ?: 0
        result = 31 * result + (actionName?.hashCode() ?: 0)
        result = 31 * result + (input?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateTime?.hashCode() ?: 0)
        result = 31 * result + (output?.hashCode() ?: 0)
        result = 31 * result + (pipelineExecutionId?.hashCode() ?: 0)
        result = 31 * result + (pipelineVersion ?: 0)
        result = 31 * result + (stageName?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ActionExecutionDetail

        if (actionExecutionId != other.actionExecutionId) return false
        if (actionName != other.actionName) return false
        if (input != other.input) return false
        if (lastUpdateTime != other.lastUpdateTime) return false
        if (output != other.output) return false
        if (pipelineExecutionId != other.pipelineExecutionId) return false
        if (pipelineVersion != other.pipelineVersion) return false
        if (stageName != other.stageName) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codepipeline.model.ActionExecutionDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The action execution ID.
         */
        public var actionExecutionId: kotlin.String? = null
        /**
         * The name of the action.
         */
        public var actionName: kotlin.String? = null
        /**
         * Input details for the action execution, such as role ARN, Region, and input artifacts.
         */
        public var input: aws.sdk.kotlin.services.codepipeline.model.ActionExecutionInput? = null
        /**
         * The last update time of the action execution.
         */
        public var lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Output details for the action execution, such as the action execution result.
         */
        public var output: aws.sdk.kotlin.services.codepipeline.model.ActionExecutionOutput? = null
        /**
         * The pipeline execution ID for the action execution.
         */
        public var pipelineExecutionId: kotlin.String? = null
        /**
         * The version of the pipeline where the action was run.
         */
        public var pipelineVersion: kotlin.Int? = null
        /**
         * The name of the stage that contains the action.
         */
        public var stageName: kotlin.String? = null
        /**
         * The start time of the action execution.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the action execution. Status categories are `InProgress`, `Succeeded`, and `Failed`.
         */
        public var status: aws.sdk.kotlin.services.codepipeline.model.ActionExecutionStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codepipeline.model.ActionExecutionDetail) : this() {
            this.actionExecutionId = x.actionExecutionId
            this.actionName = x.actionName
            this.input = x.input
            this.lastUpdateTime = x.lastUpdateTime
            this.output = x.output
            this.pipelineExecutionId = x.pipelineExecutionId
            this.pipelineVersion = x.pipelineVersion
            this.stageName = x.stageName
            this.startTime = x.startTime
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codepipeline.model.ActionExecutionDetail = ActionExecutionDetail(this)

        /**
         * construct an [aws.sdk.kotlin.services.codepipeline.model.ActionExecutionInput] inside the given [block]
         */
        public fun input(block: aws.sdk.kotlin.services.codepipeline.model.ActionExecutionInput.Builder.() -> kotlin.Unit) {
            this.input = aws.sdk.kotlin.services.codepipeline.model.ActionExecutionInput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codepipeline.model.ActionExecutionOutput] inside the given [block]
         */
        public fun output(block: aws.sdk.kotlin.services.codepipeline.model.ActionExecutionOutput.Builder.() -> kotlin.Unit) {
            this.output = aws.sdk.kotlin.services.codepipeline.model.ActionExecutionOutput.invoke(block)
        }
    }
}
