// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.model



/**
 * Input information used for an action execution.
 */
public class ActionExecutionInput private constructor(builder: Builder) {
    /**
     * Represents information about an action type.
     */
    public val actionTypeId: aws.sdk.kotlin.services.codepipeline.model.ActionTypeId? = builder.actionTypeId
    /**
     * Configuration data for an action execution.
     */
    public val configuration: Map<String, String>? = builder.configuration
    /**
     * Details of input artifacts of the action that correspond to the action execution.
     */
    public val inputArtifacts: List<ArtifactDetail>? = builder.inputArtifacts
    /**
     * The variable namespace associated with the action. All variables produced as output by this action fall under this namespace.
     */
    public val namespace: kotlin.String? = builder.namespace
    /**
     * The AWS Region for the action, such as us-east-1.
     */
    public val region: kotlin.String? = builder.region
    /**
     * Configuration data for an action execution with all variable references replaced with their real values for the execution.
     */
    public val resolvedConfiguration: Map<String, String>? = builder.resolvedConfiguration
    /**
     * The ARN of the IAM service role that performs the declared action. This is assumed through the roleArn for the pipeline.
     */
    public val roleArn: kotlin.String? = builder.roleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codepipeline.model.ActionExecutionInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ActionExecutionInput(")
        append("actionTypeId=$actionTypeId,")
        append("configuration=$configuration,")
        append("inputArtifacts=$inputArtifacts,")
        append("namespace=$namespace,")
        append("region=$region,")
        append("resolvedConfiguration=$resolvedConfiguration,")
        append("roleArn=$roleArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionTypeId?.hashCode() ?: 0
        result = 31 * result + (configuration?.hashCode() ?: 0)
        result = 31 * result + (inputArtifacts?.hashCode() ?: 0)
        result = 31 * result + (namespace?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (resolvedConfiguration?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ActionExecutionInput

        if (actionTypeId != other.actionTypeId) return false
        if (configuration != other.configuration) return false
        if (inputArtifacts != other.inputArtifacts) return false
        if (namespace != other.namespace) return false
        if (region != other.region) return false
        if (resolvedConfiguration != other.resolvedConfiguration) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codepipeline.model.ActionExecutionInput = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Represents information about an action type.
         */
        public var actionTypeId: aws.sdk.kotlin.services.codepipeline.model.ActionTypeId? = null
        /**
         * Configuration data for an action execution.
         */
        public var configuration: Map<String, String>? = null
        /**
         * Details of input artifacts of the action that correspond to the action execution.
         */
        public var inputArtifacts: List<ArtifactDetail>? = null
        /**
         * The variable namespace associated with the action. All variables produced as output by this action fall under this namespace.
         */
        public var namespace: kotlin.String? = null
        /**
         * The AWS Region for the action, such as us-east-1.
         */
        public var region: kotlin.String? = null
        /**
         * Configuration data for an action execution with all variable references replaced with their real values for the execution.
         */
        public var resolvedConfiguration: Map<String, String>? = null
        /**
         * The ARN of the IAM service role that performs the declared action. This is assumed through the roleArn for the pipeline.
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codepipeline.model.ActionExecutionInput) : this() {
            this.actionTypeId = x.actionTypeId
            this.configuration = x.configuration
            this.inputArtifacts = x.inputArtifacts
            this.namespace = x.namespace
            this.region = x.region
            this.resolvedConfiguration = x.resolvedConfiguration
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codepipeline.model.ActionExecutionInput = ActionExecutionInput(this)

        /**
         * construct an [aws.sdk.kotlin.services.codepipeline.model.ActionTypeId] inside the given [block]
         */
        public fun actionTypeId(block: aws.sdk.kotlin.services.codepipeline.model.ActionTypeId.Builder.() -> kotlin.Unit) {
            this.actionTypeId = aws.sdk.kotlin.services.codepipeline.model.ActionTypeId.invoke(block)
        }
    }
}
