// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.model



/**
 * Returns information about the settings for an action type.
 */
public class ActionTypeSettings private constructor(builder: Builder) {
    /**
     * The URL returned to the AWS CodePipeline console that provides a deep link to the resources of the external system, such as the configuration page for an AWS CodeDeploy deployment group. This link is provided as part of the action display in the pipeline.
     */
    public val entityUrlTemplate: kotlin.String? = builder.entityUrlTemplate
    /**
     * The URL returned to the AWS CodePipeline console that contains a link to the top-level landing page for the external system, such as the console page for AWS CodeDeploy. This link is shown on the pipeline view page in the AWS CodePipeline console and provides a link to the execution entity of the external action.
     */
    public val executionUrlTemplate: kotlin.String? = builder.executionUrlTemplate
    /**
     * The URL returned to the AWS CodePipeline console that contains a link to the page where customers can update or change the configuration of the external action.
     */
    public val revisionUrlTemplate: kotlin.String? = builder.revisionUrlTemplate
    /**
     * The URL of a sign-up page where users can sign up for an external service and perform initial configuration of the action provided by that service.
     */
    public val thirdPartyConfigurationUrl: kotlin.String? = builder.thirdPartyConfigurationUrl

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codepipeline.model.ActionTypeSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ActionTypeSettings(")
        append("entityUrlTemplate=$entityUrlTemplate,")
        append("executionUrlTemplate=$executionUrlTemplate,")
        append("revisionUrlTemplate=$revisionUrlTemplate,")
        append("thirdPartyConfigurationUrl=$thirdPartyConfigurationUrl)")
    }

    override fun hashCode(): kotlin.Int {
        var result = entityUrlTemplate?.hashCode() ?: 0
        result = 31 * result + (executionUrlTemplate?.hashCode() ?: 0)
        result = 31 * result + (revisionUrlTemplate?.hashCode() ?: 0)
        result = 31 * result + (thirdPartyConfigurationUrl?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ActionTypeSettings

        if (entityUrlTemplate != other.entityUrlTemplate) return false
        if (executionUrlTemplate != other.executionUrlTemplate) return false
        if (revisionUrlTemplate != other.revisionUrlTemplate) return false
        if (thirdPartyConfigurationUrl != other.thirdPartyConfigurationUrl) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codepipeline.model.ActionTypeSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The URL returned to the AWS CodePipeline console that provides a deep link to the resources of the external system, such as the configuration page for an AWS CodeDeploy deployment group. This link is provided as part of the action display in the pipeline.
         */
        public var entityUrlTemplate: kotlin.String? = null
        /**
         * The URL returned to the AWS CodePipeline console that contains a link to the top-level landing page for the external system, such as the console page for AWS CodeDeploy. This link is shown on the pipeline view page in the AWS CodePipeline console and provides a link to the execution entity of the external action.
         */
        public var executionUrlTemplate: kotlin.String? = null
        /**
         * The URL returned to the AWS CodePipeline console that contains a link to the page where customers can update or change the configuration of the external action.
         */
        public var revisionUrlTemplate: kotlin.String? = null
        /**
         * The URL of a sign-up page where users can sign up for an external service and perform initial configuration of the action provided by that service.
         */
        public var thirdPartyConfigurationUrl: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codepipeline.model.ActionTypeSettings) : this() {
            this.entityUrlTemplate = x.entityUrlTemplate
            this.executionUrlTemplate = x.executionUrlTemplate
            this.revisionUrlTemplate = x.revisionUrlTemplate
            this.thirdPartyConfigurationUrl = x.thirdPartyConfigurationUrl
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codepipeline.model.ActionTypeSettings = ActionTypeSettings(this)
    }
}
