// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.model



/**
 * The S3 bucket where artifacts for the pipeline are stored.
 *
 * You must include either `artifactStore` or `artifactStores` in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use `artifactStores`.
 */
public class ArtifactStore private constructor(builder: Builder) {
    /**
     * The encryption key used to encrypt the data in the artifact store, such as an AWS Key Management Service (AWS KMS) key. If this is undefined, the default key for Amazon S3 is used.
     */
    public val encryptionKey: aws.sdk.kotlin.services.codepipeline.model.EncryptionKey? = builder.encryptionKey
    /**
     * The S3 bucket used for storing the artifacts for a pipeline. You can specify the name of an S3 bucket but not a folder in the bucket. A folder to contain the pipeline artifacts is created for you based on the name of the pipeline. You can use any S3 bucket in the same AWS Region as the pipeline to store your pipeline artifacts.
     */
    public val location: kotlin.String? = builder.location
    /**
     * The type of the artifact store, such as S3.
     */
    public val type: aws.sdk.kotlin.services.codepipeline.model.ArtifactStoreType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codepipeline.model.ArtifactStore = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ArtifactStore(")
        append("encryptionKey=$encryptionKey,")
        append("location=$location,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = encryptionKey?.hashCode() ?: 0
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ArtifactStore

        if (encryptionKey != other.encryptionKey) return false
        if (location != other.location) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codepipeline.model.ArtifactStore = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The encryption key used to encrypt the data in the artifact store, such as an AWS Key Management Service (AWS KMS) key. If this is undefined, the default key for Amazon S3 is used.
         */
        public var encryptionKey: aws.sdk.kotlin.services.codepipeline.model.EncryptionKey? = null
        /**
         * The S3 bucket used for storing the artifacts for a pipeline. You can specify the name of an S3 bucket but not a folder in the bucket. A folder to contain the pipeline artifacts is created for you based on the name of the pipeline. You can use any S3 bucket in the same AWS Region as the pipeline to store your pipeline artifacts.
         */
        public var location: kotlin.String? = null
        /**
         * The type of the artifact store, such as S3.
         */
        public var type: aws.sdk.kotlin.services.codepipeline.model.ArtifactStoreType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codepipeline.model.ArtifactStore) : this() {
            this.encryptionKey = x.encryptionKey
            this.location = x.location
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codepipeline.model.ArtifactStore = ArtifactStore(this)

        /**
         * construct an [aws.sdk.kotlin.services.codepipeline.model.EncryptionKey] inside the given [block]
         */
        public fun encryptionKey(block: aws.sdk.kotlin.services.codepipeline.model.EncryptionKey.Builder.() -> kotlin.Unit) {
            this.encryptionKey = aws.sdk.kotlin.services.codepipeline.model.EncryptionKey.invoke(block)
        }
    }
}
