// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.model



/**
 * Represents an AWS session credentials object. These credentials are temporary credentials that are issued by AWS Secure Token Service (STS). They can be used to access input and output artifacts in the S3 bucket used to store artifact for the pipeline in AWS CodePipeline.
 */
public class AwsSessionCredentials private constructor(builder: Builder) {
    /**
     * The access key for the session.
     */
    public val accessKeyId: kotlin.String? = builder.accessKeyId
    /**
     * The secret access key for the session.
     */
    public val secretAccessKey: kotlin.String? = builder.secretAccessKey
    /**
     * The token for the session.
     */
    public val sessionToken: kotlin.String? = builder.sessionToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codepipeline.model.AwsSessionCredentials = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsSessionCredentials(")
        append("accessKeyId=*** Sensitive Data Redacted ***,")
        append("secretAccessKey=*** Sensitive Data Redacted ***,")
        append("sessionToken=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessKeyId?.hashCode() ?: 0
        result = 31 * result + (secretAccessKey?.hashCode() ?: 0)
        result = 31 * result + (sessionToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsSessionCredentials

        if (accessKeyId != other.accessKeyId) return false
        if (secretAccessKey != other.secretAccessKey) return false
        if (sessionToken != other.sessionToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codepipeline.model.AwsSessionCredentials = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The access key for the session.
         */
        public var accessKeyId: kotlin.String? = null
        /**
         * The secret access key for the session.
         */
        public var secretAccessKey: kotlin.String? = null
        /**
         * The token for the session.
         */
        public var sessionToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codepipeline.model.AwsSessionCredentials) : this() {
            this.accessKeyId = x.accessKeyId
            this.secretAccessKey = x.secretAccessKey
            this.sessionToken = x.sessionToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codepipeline.model.AwsSessionCredentials = AwsSessionCredentials(this)
    }
}
