// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.model



/**
 * Represents the input of a CreateCustomActionType operation.
 */
public class CreateCustomActionTypeRequest private constructor(builder: Builder) {
    /**
     * The category of the custom action, such as a build action or a test action.
     */
    public val category: aws.sdk.kotlin.services.codepipeline.model.ActionCategory? = builder.category
    /**
     * The configuration properties for the custom action.
     *
     * You can refer to a name in the configuration properties of the custom action within the URL templates by following the format of {Config:name}, as long as the configuration property is both required and not secret. For more information, see [Create a Custom Action for a Pipeline](https://docs.aws.amazon.com/codepipeline/latest/userguide/how-to-create-custom-action.html).
     */
    public val configurationProperties: List<ActionConfigurationProperty>? = builder.configurationProperties
    /**
     * The details of the input artifact for the action, such as its commit ID.
     */
    public val inputArtifactDetails: aws.sdk.kotlin.services.codepipeline.model.ArtifactDetails? = builder.inputArtifactDetails
    /**
     * The details of the output artifact of the action, such as its commit ID.
     */
    public val outputArtifactDetails: aws.sdk.kotlin.services.codepipeline.model.ArtifactDetails? = builder.outputArtifactDetails
    /**
     * The provider of the service used in the custom action, such as AWS CodeDeploy.
     */
    public val provider: kotlin.String? = builder.provider
    /**
     * URLs that provide users information about this custom action.
     */
    public val settings: aws.sdk.kotlin.services.codepipeline.model.ActionTypeSettings? = builder.settings
    /**
     * The tags for the custom action.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The version identifier of the custom action.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codepipeline.model.CreateCustomActionTypeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateCustomActionTypeRequest(")
        append("category=$category,")
        append("configurationProperties=$configurationProperties,")
        append("inputArtifactDetails=$inputArtifactDetails,")
        append("outputArtifactDetails=$outputArtifactDetails,")
        append("provider=$provider,")
        append("settings=$settings,")
        append("tags=$tags,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = category?.hashCode() ?: 0
        result = 31 * result + (configurationProperties?.hashCode() ?: 0)
        result = 31 * result + (inputArtifactDetails?.hashCode() ?: 0)
        result = 31 * result + (outputArtifactDetails?.hashCode() ?: 0)
        result = 31 * result + (provider?.hashCode() ?: 0)
        result = 31 * result + (settings?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateCustomActionTypeRequest

        if (category != other.category) return false
        if (configurationProperties != other.configurationProperties) return false
        if (inputArtifactDetails != other.inputArtifactDetails) return false
        if (outputArtifactDetails != other.outputArtifactDetails) return false
        if (provider != other.provider) return false
        if (settings != other.settings) return false
        if (tags != other.tags) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codepipeline.model.CreateCustomActionTypeRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The category of the custom action, such as a build action or a test action.
         */
        public var category: aws.sdk.kotlin.services.codepipeline.model.ActionCategory? = null
        /**
         * The configuration properties for the custom action.
         *
         * You can refer to a name in the configuration properties of the custom action within the URL templates by following the format of {Config:name}, as long as the configuration property is both required and not secret. For more information, see [Create a Custom Action for a Pipeline](https://docs.aws.amazon.com/codepipeline/latest/userguide/how-to-create-custom-action.html).
         */
        public var configurationProperties: List<ActionConfigurationProperty>? = null
        /**
         * The details of the input artifact for the action, such as its commit ID.
         */
        public var inputArtifactDetails: aws.sdk.kotlin.services.codepipeline.model.ArtifactDetails? = null
        /**
         * The details of the output artifact of the action, such as its commit ID.
         */
        public var outputArtifactDetails: aws.sdk.kotlin.services.codepipeline.model.ArtifactDetails? = null
        /**
         * The provider of the service used in the custom action, such as AWS CodeDeploy.
         */
        public var provider: kotlin.String? = null
        /**
         * URLs that provide users information about this custom action.
         */
        public var settings: aws.sdk.kotlin.services.codepipeline.model.ActionTypeSettings? = null
        /**
         * The tags for the custom action.
         */
        public var tags: List<Tag>? = null
        /**
         * The version identifier of the custom action.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codepipeline.model.CreateCustomActionTypeRequest) : this() {
            this.category = x.category
            this.configurationProperties = x.configurationProperties
            this.inputArtifactDetails = x.inputArtifactDetails
            this.outputArtifactDetails = x.outputArtifactDetails
            this.provider = x.provider
            this.settings = x.settings
            this.tags = x.tags
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codepipeline.model.CreateCustomActionTypeRequest = CreateCustomActionTypeRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.codepipeline.model.ArtifactDetails] inside the given [block]
         */
        public fun inputArtifactDetails(block: aws.sdk.kotlin.services.codepipeline.model.ArtifactDetails.Builder.() -> kotlin.Unit) {
            this.inputArtifactDetails = aws.sdk.kotlin.services.codepipeline.model.ArtifactDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codepipeline.model.ArtifactDetails] inside the given [block]
         */
        public fun outputArtifactDetails(block: aws.sdk.kotlin.services.codepipeline.model.ArtifactDetails.Builder.() -> kotlin.Unit) {
            this.outputArtifactDetails = aws.sdk.kotlin.services.codepipeline.model.ArtifactDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codepipeline.model.ActionTypeSettings] inside the given [block]
         */
        public fun settings(block: aws.sdk.kotlin.services.codepipeline.model.ActionTypeSettings.Builder.() -> kotlin.Unit) {
            this.settings = aws.sdk.kotlin.services.codepipeline.model.ActionTypeSettings.invoke(block)
        }
    }
}
