// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents the output of a `GetPipelineState` action.
 */
public class GetPipelineStateResponse private constructor(builder: Builder) {
    /**
     * The date and time the pipeline was created, in timestamp format.
     */
    public val created: aws.smithy.kotlin.runtime.time.Instant? = builder.created
    /**
     * The name of the pipeline for which you want to get the state.
     */
    public val pipelineName: kotlin.String? = builder.pipelineName
    /**
     * The version number of the pipeline.
     *
     * A newly created pipeline is always assigned a version number of `1`.
     */
    public val pipelineVersion: kotlin.Int? = builder.pipelineVersion
    /**
     * A list of the pipeline stage output information, including stage name, state, most recent run details, whether the stage is disabled, and other data.
     */
    public val stageStates: List<StageState>? = builder.stageStates
    /**
     * The date and time the pipeline was last updated, in timestamp format.
     */
    public val updated: aws.smithy.kotlin.runtime.time.Instant? = builder.updated

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codepipeline.model.GetPipelineStateResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetPipelineStateResponse(")
        append("created=$created,")
        append("pipelineName=$pipelineName,")
        append("pipelineVersion=$pipelineVersion,")
        append("stageStates=$stageStates,")
        append("updated=$updated)")
    }

    override fun hashCode(): kotlin.Int {
        var result = created?.hashCode() ?: 0
        result = 31 * result + (pipelineName?.hashCode() ?: 0)
        result = 31 * result + (pipelineVersion ?: 0)
        result = 31 * result + (stageStates?.hashCode() ?: 0)
        result = 31 * result + (updated?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetPipelineStateResponse

        if (created != other.created) return false
        if (pipelineName != other.pipelineName) return false
        if (pipelineVersion != other.pipelineVersion) return false
        if (stageStates != other.stageStates) return false
        if (updated != other.updated) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codepipeline.model.GetPipelineStateResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time the pipeline was created, in timestamp format.
         */
        public var created: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the pipeline for which you want to get the state.
         */
        public var pipelineName: kotlin.String? = null
        /**
         * The version number of the pipeline.
         *
         * A newly created pipeline is always assigned a version number of `1`.
         */
        public var pipelineVersion: kotlin.Int? = null
        /**
         * A list of the pipeline stage output information, including stage name, state, most recent run details, whether the stage is disabled, and other data.
         */
        public var stageStates: List<StageState>? = null
        /**
         * The date and time the pipeline was last updated, in timestamp format.
         */
        public var updated: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codepipeline.model.GetPipelineStateResponse) : this() {
            this.created = x.created
            this.pipelineName = x.pipelineName
            this.pipelineVersion = x.pipelineVersion
            this.stageStates = x.stageStates
            this.updated = x.updated
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codepipeline.model.GetPipelineStateResponse = GetPipelineStateResponse(this)
    }
}
