// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.model



/**
 * Represents other information about a job required for a job worker to complete the job.
 */
public class JobData private constructor(builder: Builder) {
    /**
     * Represents information about an action configuration.
     */
    public val actionConfiguration: aws.sdk.kotlin.services.codepipeline.model.ActionConfiguration? = builder.actionConfiguration
    /**
     * Represents information about an action type.
     */
    public val actionTypeId: aws.sdk.kotlin.services.codepipeline.model.ActionTypeId? = builder.actionTypeId
    /**
     * Represents an AWS session credentials object. These credentials are temporary credentials that are issued by AWS Secure Token Service (STS). They can be used to access input and output artifacts in the S3 bucket used to store artifacts for the pipeline in AWS CodePipeline.
     */
    public val artifactCredentials: aws.sdk.kotlin.services.codepipeline.model.AwsSessionCredentials? = builder.artifactCredentials
    /**
     * A system-generated token, such as a AWS CodeDeploy deployment ID, required by a job to continue the job asynchronously.
     */
    public val continuationToken: kotlin.String? = builder.continuationToken
    /**
     * Represents information about the key used to encrypt data in the artifact store, such as an AWS Key Management Service (AWS KMS) key.
     */
    public val encryptionKey: aws.sdk.kotlin.services.codepipeline.model.EncryptionKey? = builder.encryptionKey
    /**
     * The artifact supplied to the job.
     */
    public val inputArtifacts: List<Artifact>? = builder.inputArtifacts
    /**
     * The output of the job.
     */
    public val outputArtifacts: List<Artifact>? = builder.outputArtifacts
    /**
     * Represents information about a pipeline to a job worker.
     *
     * Includes `pipelineArn` and `pipelineExecutionId` for custom jobs.
     */
    public val pipelineContext: aws.sdk.kotlin.services.codepipeline.model.PipelineContext? = builder.pipelineContext

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codepipeline.model.JobData = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobData(")
        append("actionConfiguration=$actionConfiguration,")
        append("actionTypeId=$actionTypeId,")
        append("artifactCredentials=*** Sensitive Data Redacted ***,")
        append("continuationToken=$continuationToken,")
        append("encryptionKey=$encryptionKey,")
        append("inputArtifacts=$inputArtifacts,")
        append("outputArtifacts=$outputArtifacts,")
        append("pipelineContext=$pipelineContext)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionConfiguration?.hashCode() ?: 0
        result = 31 * result + (actionTypeId?.hashCode() ?: 0)
        result = 31 * result + (artifactCredentials?.hashCode() ?: 0)
        result = 31 * result + (continuationToken?.hashCode() ?: 0)
        result = 31 * result + (encryptionKey?.hashCode() ?: 0)
        result = 31 * result + (inputArtifacts?.hashCode() ?: 0)
        result = 31 * result + (outputArtifacts?.hashCode() ?: 0)
        result = 31 * result + (pipelineContext?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobData

        if (actionConfiguration != other.actionConfiguration) return false
        if (actionTypeId != other.actionTypeId) return false
        if (artifactCredentials != other.artifactCredentials) return false
        if (continuationToken != other.continuationToken) return false
        if (encryptionKey != other.encryptionKey) return false
        if (inputArtifacts != other.inputArtifacts) return false
        if (outputArtifacts != other.outputArtifacts) return false
        if (pipelineContext != other.pipelineContext) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codepipeline.model.JobData = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Represents information about an action configuration.
         */
        public var actionConfiguration: aws.sdk.kotlin.services.codepipeline.model.ActionConfiguration? = null
        /**
         * Represents information about an action type.
         */
        public var actionTypeId: aws.sdk.kotlin.services.codepipeline.model.ActionTypeId? = null
        /**
         * Represents an AWS session credentials object. These credentials are temporary credentials that are issued by AWS Secure Token Service (STS). They can be used to access input and output artifacts in the S3 bucket used to store artifacts for the pipeline in AWS CodePipeline.
         */
        public var artifactCredentials: aws.sdk.kotlin.services.codepipeline.model.AwsSessionCredentials? = null
        /**
         * A system-generated token, such as a AWS CodeDeploy deployment ID, required by a job to continue the job asynchronously.
         */
        public var continuationToken: kotlin.String? = null
        /**
         * Represents information about the key used to encrypt data in the artifact store, such as an AWS Key Management Service (AWS KMS) key.
         */
        public var encryptionKey: aws.sdk.kotlin.services.codepipeline.model.EncryptionKey? = null
        /**
         * The artifact supplied to the job.
         */
        public var inputArtifacts: List<Artifact>? = null
        /**
         * The output of the job.
         */
        public var outputArtifacts: List<Artifact>? = null
        /**
         * Represents information about a pipeline to a job worker.
         *
         * Includes `pipelineArn` and `pipelineExecutionId` for custom jobs.
         */
        public var pipelineContext: aws.sdk.kotlin.services.codepipeline.model.PipelineContext? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codepipeline.model.JobData) : this() {
            this.actionConfiguration = x.actionConfiguration
            this.actionTypeId = x.actionTypeId
            this.artifactCredentials = x.artifactCredentials
            this.continuationToken = x.continuationToken
            this.encryptionKey = x.encryptionKey
            this.inputArtifacts = x.inputArtifacts
            this.outputArtifacts = x.outputArtifacts
            this.pipelineContext = x.pipelineContext
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codepipeline.model.JobData = JobData(this)

        /**
         * construct an [aws.sdk.kotlin.services.codepipeline.model.ActionConfiguration] inside the given [block]
         */
        public fun actionConfiguration(block: aws.sdk.kotlin.services.codepipeline.model.ActionConfiguration.Builder.() -> kotlin.Unit) {
            this.actionConfiguration = aws.sdk.kotlin.services.codepipeline.model.ActionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codepipeline.model.ActionTypeId] inside the given [block]
         */
        public fun actionTypeId(block: aws.sdk.kotlin.services.codepipeline.model.ActionTypeId.Builder.() -> kotlin.Unit) {
            this.actionTypeId = aws.sdk.kotlin.services.codepipeline.model.ActionTypeId.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codepipeline.model.AwsSessionCredentials] inside the given [block]
         */
        public fun artifactCredentials(block: aws.sdk.kotlin.services.codepipeline.model.AwsSessionCredentials.Builder.() -> kotlin.Unit) {
            this.artifactCredentials = aws.sdk.kotlin.services.codepipeline.model.AwsSessionCredentials.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codepipeline.model.EncryptionKey] inside the given [block]
         */
        public fun encryptionKey(block: aws.sdk.kotlin.services.codepipeline.model.EncryptionKey.Builder.() -> kotlin.Unit) {
            this.encryptionKey = aws.sdk.kotlin.services.codepipeline.model.EncryptionKey.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codepipeline.model.PipelineContext] inside the given [block]
         */
        public fun pipelineContext(block: aws.sdk.kotlin.services.codepipeline.model.PipelineContext.Builder.() -> kotlin.Unit) {
            this.pipelineContext = aws.sdk.kotlin.services.codepipeline.model.PipelineContext.invoke(block)
        }
    }
}
