// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.model



/**
 * Represents the input of a `ListPipelineExecutions` action.
 */
public class ListPipelineExecutionsRequest private constructor(builder: Builder) {
    /**
     * The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned nextToken value. Pipeline history is limited to the most recent 12 months, based on pipeline execution start times. Default value is 100.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token that was returned from the previous `ListPipelineExecutions` call, which can be used to return the next set of pipeline executions in the list.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The name of the pipeline for which you want to get execution summary information.
     */
    public val pipelineName: kotlin.String? = builder.pipelineName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codepipeline.model.ListPipelineExecutionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListPipelineExecutionsRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("pipelineName=$pipelineName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (pipelineName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListPipelineExecutionsRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (pipelineName != other.pipelineName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codepipeline.model.ListPipelineExecutionsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned nextToken value. Pipeline history is limited to the most recent 12 months, based on pipeline execution start times. Default value is 100.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token that was returned from the previous `ListPipelineExecutions` call, which can be used to return the next set of pipeline executions in the list.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The name of the pipeline for which you want to get execution summary information.
         */
        public var pipelineName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codepipeline.model.ListPipelineExecutionsRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.pipelineName = x.pipelineName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codepipeline.model.ListPipelineExecutionsRequest = ListPipelineExecutionsRequest(this)
    }
}
