// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.model



/**
 * Represents information about an execution of a pipeline.
 */
public class PipelineExecution private constructor(builder: Builder) {
    /**
     * A list of `ArtifactRevision` objects included in a pipeline execution.
     */
    public val artifactRevisions: List<ArtifactRevision>? = builder.artifactRevisions
    /**
     * The ID of the pipeline execution.
     */
    public val pipelineExecutionId: kotlin.String? = builder.pipelineExecutionId
    /**
     * The name of the pipeline with the specified pipeline execution.
     */
    public val pipelineName: kotlin.String? = builder.pipelineName
    /**
     * The version number of the pipeline with the specified pipeline execution.
     */
    public val pipelineVersion: kotlin.Int? = builder.pipelineVersion
    /**
     * The status of the pipeline execution.
     * + Cancelled: The pipeline’s definition was updated before the pipeline execution could be completed.
     * + InProgress: The pipeline execution is currently running.
     * + Stopped: The pipeline execution was manually stopped. For more information, see [Stopped Executions](https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped).
     * + Stopping: The pipeline execution received a request to be manually stopped. Depending on the selected stop mode, the execution is either completing or abandoning in-progress actions. For more information, see [Stopped Executions](https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped).
     * + Succeeded: The pipeline execution was completed successfully.
     * + Superseded: While this pipeline execution was waiting for the next stage to be completed, a newer pipeline execution advanced and continued through the pipeline instead. For more information, see [Superseded Executions](https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-superseded).
     * + Failed: The pipeline execution was not completed successfully.
     */
    public val status: aws.sdk.kotlin.services.codepipeline.model.PipelineExecutionStatus? = builder.status
    /**
     * A summary that contains a description of the pipeline execution status.
     */
    public val statusSummary: kotlin.String? = builder.statusSummary

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codepipeline.model.PipelineExecution = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PipelineExecution(")
        append("artifactRevisions=$artifactRevisions,")
        append("pipelineExecutionId=$pipelineExecutionId,")
        append("pipelineName=$pipelineName,")
        append("pipelineVersion=$pipelineVersion,")
        append("status=$status,")
        append("statusSummary=$statusSummary)")
    }

    override fun hashCode(): kotlin.Int {
        var result = artifactRevisions?.hashCode() ?: 0
        result = 31 * result + (pipelineExecutionId?.hashCode() ?: 0)
        result = 31 * result + (pipelineName?.hashCode() ?: 0)
        result = 31 * result + (pipelineVersion ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusSummary?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PipelineExecution

        if (artifactRevisions != other.artifactRevisions) return false
        if (pipelineExecutionId != other.pipelineExecutionId) return false
        if (pipelineName != other.pipelineName) return false
        if (pipelineVersion != other.pipelineVersion) return false
        if (status != other.status) return false
        if (statusSummary != other.statusSummary) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codepipeline.model.PipelineExecution = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of `ArtifactRevision` objects included in a pipeline execution.
         */
        public var artifactRevisions: List<ArtifactRevision>? = null
        /**
         * The ID of the pipeline execution.
         */
        public var pipelineExecutionId: kotlin.String? = null
        /**
         * The name of the pipeline with the specified pipeline execution.
         */
        public var pipelineName: kotlin.String? = null
        /**
         * The version number of the pipeline with the specified pipeline execution.
         */
        public var pipelineVersion: kotlin.Int? = null
        /**
         * The status of the pipeline execution.
         * + Cancelled: The pipeline’s definition was updated before the pipeline execution could be completed.
         * + InProgress: The pipeline execution is currently running.
         * + Stopped: The pipeline execution was manually stopped. For more information, see [Stopped Executions](https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped).
         * + Stopping: The pipeline execution received a request to be manually stopped. Depending on the selected stop mode, the execution is either completing or abandoning in-progress actions. For more information, see [Stopped Executions](https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped).
         * + Succeeded: The pipeline execution was completed successfully.
         * + Superseded: While this pipeline execution was waiting for the next stage to be completed, a newer pipeline execution advanced and continued through the pipeline instead. For more information, see [Superseded Executions](https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-superseded).
         * + Failed: The pipeline execution was not completed successfully.
         */
        public var status: aws.sdk.kotlin.services.codepipeline.model.PipelineExecutionStatus? = null
        /**
         * A summary that contains a description of the pipeline execution status.
         */
        public var statusSummary: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codepipeline.model.PipelineExecution) : this() {
            this.artifactRevisions = x.artifactRevisions
            this.pipelineExecutionId = x.pipelineExecutionId
            this.pipelineName = x.pipelineName
            this.pipelineVersion = x.pipelineVersion
            this.status = x.status
            this.statusSummary = x.statusSummary
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codepipeline.model.PipelineExecution = PipelineExecution(this)
    }
}
