// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.model



/**
 * Information about the version (or revision) of a source artifact that initiated a pipeline execution.
 */
public class SourceRevision private constructor(builder: Builder) {
    /**
     * The name of the action that processed the revision to the source artifact.
     */
    public val actionName: kotlin.String? = builder.actionName
    /**
     * The system-generated unique ID that identifies the revision number of the artifact.
     */
    public val revisionId: kotlin.String? = builder.revisionId
    /**
     * Summary information about the most recent revision of the artifact. For GitHub and AWS CodeCommit repositories, the commit message. For Amazon S3 buckets or actions, the user-provided content of a `codepipeline-artifact-revision-summary` key specified in the object metadata.
     */
    public val revisionSummary: kotlin.String? = builder.revisionSummary
    /**
     * The commit ID for the artifact revision. For artifacts stored in GitHub or AWS CodeCommit repositories, the commit ID is linked to a commit details page.
     */
    public val revisionUrl: kotlin.String? = builder.revisionUrl

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codepipeline.model.SourceRevision = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SourceRevision(")
        append("actionName=$actionName,")
        append("revisionId=$revisionId,")
        append("revisionSummary=$revisionSummary,")
        append("revisionUrl=$revisionUrl)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionName?.hashCode() ?: 0
        result = 31 * result + (revisionId?.hashCode() ?: 0)
        result = 31 * result + (revisionSummary?.hashCode() ?: 0)
        result = 31 * result + (revisionUrl?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SourceRevision

        if (actionName != other.actionName) return false
        if (revisionId != other.revisionId) return false
        if (revisionSummary != other.revisionSummary) return false
        if (revisionUrl != other.revisionUrl) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codepipeline.model.SourceRevision = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the action that processed the revision to the source artifact.
         */
        public var actionName: kotlin.String? = null
        /**
         * The system-generated unique ID that identifies the revision number of the artifact.
         */
        public var revisionId: kotlin.String? = null
        /**
         * Summary information about the most recent revision of the artifact. For GitHub and AWS CodeCommit repositories, the commit message. For Amazon S3 buckets or actions, the user-provided content of a `codepipeline-artifact-revision-summary` key specified in the object metadata.
         */
        public var revisionSummary: kotlin.String? = null
        /**
         * The commit ID for the artifact revision. For artifacts stored in GitHub or AWS CodeCommit repositories, the commit ID is linked to a commit details page.
         */
        public var revisionUrl: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codepipeline.model.SourceRevision) : this() {
            this.actionName = x.actionName
            this.revisionId = x.revisionId
            this.revisionSummary = x.revisionSummary
            this.revisionUrl = x.revisionUrl
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codepipeline.model.SourceRevision = SourceRevision(this)
    }
}
