// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codepipeline.model.CodePipelineException
import aws.sdk.kotlin.services.codepipeline.model.PollForThirdPartyJobsResponse
import aws.sdk.kotlin.services.codepipeline.model.ThirdPartyJob
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class PollForThirdPartyJobsOperationDeserializer: HttpDeserialize<PollForThirdPartyJobsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): PollForThirdPartyJobsResponse {
        if (!response.status.isSuccess()) {
            throwPollForThirdPartyJobsError(context, response)
        }
        val builder = PollForThirdPartyJobsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePollForThirdPartyJobsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwPollForThirdPartyJobsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodePipelineException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ActionTypeNotFoundException" -> ActionTypeNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodePipelineException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePollForThirdPartyJobsOperationBody(builder: PollForThirdPartyJobsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val JOBS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("jobs"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(JOBS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                JOBS_DESCRIPTOR.index -> builder.jobs =
                    deserializer.deserializeList(JOBS_DESCRIPTOR) {
                        val col0 = mutableListOf<ThirdPartyJob>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeThirdPartyJobDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
