// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codepipeline.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codepipeline.model.CodePipelineException
import aws.sdk.kotlin.services.codepipeline.model.ListWebhookItem
import aws.sdk.kotlin.services.codepipeline.model.PutWebhookResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutWebhookOperationDeserializer: HttpDeserialize<PutWebhookResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): PutWebhookResponse {
        if (!response.status.isSuccess()) {
            throwPutWebhookError(context, response)
        }
        val builder = PutWebhookResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePutWebhookOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwPutWebhookError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodePipelineException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConcurrentModificationException" -> ConcurrentModificationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidTagsException" -> InvalidTagsExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidWebhookAuthenticationParametersException" -> InvalidWebhookAuthenticationParametersExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidWebhookFilterPatternException" -> InvalidWebhookFilterPatternExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "PipelineNotFoundException" -> PipelineNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyTagsException" -> TooManyTagsExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodePipelineException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutWebhookOperationBody(builder: PutWebhookResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val WEBHOOK_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("webhook"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(WEBHOOK_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                WEBHOOK_DESCRIPTOR.index -> builder.webhook = deserializeListWebhookItemDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
