// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codestar

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.codestar.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.codestar.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * # AWS CodeStar
 * This is the API reference for AWS CodeStar. This reference provides descriptions of the operations and data types for the AWS CodeStar API along with usage examples.
 *
 * You can use the AWS CodeStar API to work with:
 *
 * Projects and their resources, by calling the following:
 * + `DeleteProject`, which deletes a project.
 * + `DescribeProject`, which lists the attributes of a project.
 * + `ListProjects`, which lists all projects associated with your AWS account.
 * + `ListResources`, which lists the resources associated with a project.
 * + `ListTagsForProject`, which lists the tags associated with a project.
 * + `TagProject`, which adds tags to a project.
 * + `UntagProject`, which removes tags from a project.
 * + `UpdateProject`, which updates the attributes of a project.
 *
 * Teams and team members, by calling the following:
 * + `AssociateTeamMember`, which adds an IAM user to the team for a project.
 * + `DisassociateTeamMember`, which removes an IAM user from the team for a project.
 * + `ListTeamMembers`, which lists all the IAM users in the team for a project, including their roles and attributes.
 * + `UpdateTeamMember`, which updates a team member's attributes in a project.
 *
 * Users, by calling the following:
 * + `CreateUserProfile`, which creates a user profile that contains data associated with the user across all projects.
 * + `DeleteUserProfile`, which deletes all user profile information across all projects.
 * + `DescribeUserProfile`, which describes the profile of a user.
 * + `ListUserProfiles`, which lists all user profiles.
 * + `UpdateUserProfile`, which updates the profile for a user.
 */
interface CodeStarClient : SdkClient {

    override val serviceName: String
        get() = "CodeStar"
    /**
     * CodeStarClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): CodeStarClient {
            val config = Config.Builder().apply(block).build()
            return DefaultCodeStarClient(config)
        }

        operator fun invoke(config: Config): CodeStarClient = DefaultCodeStarClient(config)

        /**
         * Construct a [CodeStarClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): CodeStarClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultCodeStarClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Adds an IAM user to the team for an AWS CodeStar project.
     */
    suspend fun associateTeamMember(input: AssociateTeamMemberRequest): AssociateTeamMemberResponse

    /**
     * Adds an IAM user to the team for an AWS CodeStar project.
     */
    suspend fun associateTeamMember(block: AssociateTeamMemberRequest.Builder.() -> Unit) = associateTeamMember(AssociateTeamMemberRequest.Builder().apply(block).build())

    /**
     * Creates a project, including project resources. This action creates a project based on a submitted project request. A set of source code files and a toolchain template file can be included with the project request. If these are not provided, an empty project is created.
     */
    suspend fun createProject(input: CreateProjectRequest): CreateProjectResponse

    /**
     * Creates a project, including project resources. This action creates a project based on a submitted project request. A set of source code files and a toolchain template file can be included with the project request. If these are not provided, an empty project is created.
     */
    suspend fun createProject(block: CreateProjectRequest.Builder.() -> Unit) = createProject(CreateProjectRequest.Builder().apply(block).build())

    /**
     * Creates a profile for a user that includes user preferences, such as the display name and email address assocciated with the user, in AWS CodeStar. The user profile is not project-specific. Information in the user profile is displayed wherever the user's information appears to other users in AWS CodeStar.
     */
    suspend fun createUserProfile(input: CreateUserProfileRequest): CreateUserProfileResponse

    /**
     * Creates a profile for a user that includes user preferences, such as the display name and email address assocciated with the user, in AWS CodeStar. The user profile is not project-specific. Information in the user profile is displayed wherever the user's information appears to other users in AWS CodeStar.
     */
    suspend fun createUserProfile(block: CreateUserProfileRequest.Builder.() -> Unit) = createUserProfile(CreateUserProfileRequest.Builder().apply(block).build())

    /**
     * Deletes a project, including project resources. Does not delete users associated with the project, but does delete the IAM roles that allowed access to the project.
     */
    suspend fun deleteProject(input: DeleteProjectRequest): DeleteProjectResponse

    /**
     * Deletes a project, including project resources. Does not delete users associated with the project, but does delete the IAM roles that allowed access to the project.
     */
    suspend fun deleteProject(block: DeleteProjectRequest.Builder.() -> Unit) = deleteProject(DeleteProjectRequest.Builder().apply(block).build())

    /**
     * Deletes a user profile in AWS CodeStar, including all personal preference data associated with that profile, such as display name and email address. It does not delete the history of that user, for example the history of commits made by that user.
     */
    suspend fun deleteUserProfile(input: DeleteUserProfileRequest): DeleteUserProfileResponse

    /**
     * Deletes a user profile in AWS CodeStar, including all personal preference data associated with that profile, such as display name and email address. It does not delete the history of that user, for example the history of commits made by that user.
     */
    suspend fun deleteUserProfile(block: DeleteUserProfileRequest.Builder.() -> Unit) = deleteUserProfile(DeleteUserProfileRequest.Builder().apply(block).build())

    /**
     * Describes a project and its resources.
     */
    suspend fun describeProject(input: DescribeProjectRequest): DescribeProjectResponse

    /**
     * Describes a project and its resources.
     */
    suspend fun describeProject(block: DescribeProjectRequest.Builder.() -> Unit) = describeProject(DescribeProjectRequest.Builder().apply(block).build())

    /**
     * Describes a user in AWS CodeStar and the user attributes across all projects.
     */
    suspend fun describeUserProfile(input: DescribeUserProfileRequest): DescribeUserProfileResponse

    /**
     * Describes a user in AWS CodeStar and the user attributes across all projects.
     */
    suspend fun describeUserProfile(block: DescribeUserProfileRequest.Builder.() -> Unit) = describeUserProfile(DescribeUserProfileRequest.Builder().apply(block).build())

    /**
     * Removes a user from a project. Removing a user from a project also removes the IAM policies from that user that allowed access to the project and its resources. Disassociating a team member does not remove that user's profile from AWS CodeStar. It does not remove the user from IAM.
     */
    suspend fun disassociateTeamMember(input: DisassociateTeamMemberRequest): DisassociateTeamMemberResponse

    /**
     * Removes a user from a project. Removing a user from a project also removes the IAM policies from that user that allowed access to the project and its resources. Disassociating a team member does not remove that user's profile from AWS CodeStar. It does not remove the user from IAM.
     */
    suspend fun disassociateTeamMember(block: DisassociateTeamMemberRequest.Builder.() -> Unit) = disassociateTeamMember(DisassociateTeamMemberRequest.Builder().apply(block).build())

    /**
     * Lists all projects in AWS CodeStar associated with your AWS account.
     */
    suspend fun listProjects(input: ListProjectsRequest = ListProjectsRequest {}): ListProjectsResponse

    /**
     * Lists all projects in AWS CodeStar associated with your AWS account.
     */
    suspend fun listProjects(block: ListProjectsRequest.Builder.() -> Unit) = listProjects(ListProjectsRequest.Builder().apply(block).build())

    /**
     * Lists resources associated with a project in AWS CodeStar.
     */
    suspend fun listResources(input: ListResourcesRequest): ListResourcesResponse

    /**
     * Lists resources associated with a project in AWS CodeStar.
     */
    suspend fun listResources(block: ListResourcesRequest.Builder.() -> Unit) = listResources(ListResourcesRequest.Builder().apply(block).build())

    /**
     * Gets the tags for a project.
     */
    suspend fun listTagsForProject(input: ListTagsForProjectRequest): ListTagsForProjectResponse

    /**
     * Gets the tags for a project.
     */
    suspend fun listTagsForProject(block: ListTagsForProjectRequest.Builder.() -> Unit) = listTagsForProject(ListTagsForProjectRequest.Builder().apply(block).build())

    /**
     * Lists all team members associated with a project.
     */
    suspend fun listTeamMembers(input: ListTeamMembersRequest): ListTeamMembersResponse

    /**
     * Lists all team members associated with a project.
     */
    suspend fun listTeamMembers(block: ListTeamMembersRequest.Builder.() -> Unit) = listTeamMembers(ListTeamMembersRequest.Builder().apply(block).build())

    /**
     * Lists all the user profiles configured for your AWS account in AWS CodeStar.
     */
    suspend fun listUserProfiles(input: ListUserProfilesRequest = ListUserProfilesRequest {}): ListUserProfilesResponse

    /**
     * Lists all the user profiles configured for your AWS account in AWS CodeStar.
     */
    suspend fun listUserProfiles(block: ListUserProfilesRequest.Builder.() -> Unit) = listUserProfiles(ListUserProfilesRequest.Builder().apply(block).build())

    /**
     * Adds tags to a project.
     */
    suspend fun tagProject(input: TagProjectRequest): TagProjectResponse

    /**
     * Adds tags to a project.
     */
    suspend fun tagProject(block: TagProjectRequest.Builder.() -> Unit) = tagProject(TagProjectRequest.Builder().apply(block).build())

    /**
     * Removes tags from a project.
     */
    suspend fun untagProject(input: UntagProjectRequest): UntagProjectResponse

    /**
     * Removes tags from a project.
     */
    suspend fun untagProject(block: UntagProjectRequest.Builder.() -> Unit) = untagProject(UntagProjectRequest.Builder().apply(block).build())

    /**
     * Updates a project in AWS CodeStar.
     */
    suspend fun updateProject(input: UpdateProjectRequest): UpdateProjectResponse

    /**
     * Updates a project in AWS CodeStar.
     */
    suspend fun updateProject(block: UpdateProjectRequest.Builder.() -> Unit) = updateProject(UpdateProjectRequest.Builder().apply(block).build())

    /**
     * Updates a team member's attributes in an AWS CodeStar project. For example, you can change a team member's role in the project, or change whether they have remote access to project resources.
     */
    suspend fun updateTeamMember(input: UpdateTeamMemberRequest): UpdateTeamMemberResponse

    /**
     * Updates a team member's attributes in an AWS CodeStar project. For example, you can change a team member's role in the project, or change whether they have remote access to project resources.
     */
    suspend fun updateTeamMember(block: UpdateTeamMemberRequest.Builder.() -> Unit) = updateTeamMember(UpdateTeamMemberRequest.Builder().apply(block).build())

    /**
     * Updates a user's profile in AWS CodeStar. The user profile is not project-specific. Information in the user profile is displayed wherever the user's information appears to other users in AWS CodeStar.
     */
    suspend fun updateUserProfile(input: UpdateUserProfileRequest): UpdateUserProfileResponse

    /**
     * Updates a user's profile in AWS CodeStar. The user profile is not project-specific. Information in the user profile is displayed wherever the user's information appears to other users in AWS CodeStar.
     */
    suspend fun updateUserProfile(block: UpdateUserProfileRequest.Builder.() -> Unit) = updateUserProfile(UpdateUserProfileRequest.Builder().apply(block).build())
}
