// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codestar.model



/**
 * Information about the GitHub repository to be created in AWS CodeStar. This is where the source code files provided with the project request will be uploaded after project creation.
 */
public class GitHubCodeDestination private constructor(builder: Builder) {
    /**
     * Description for the GitHub repository to be created in AWS CodeStar. This description displays in GitHub after the repository is created.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Whether to enable issues for the GitHub repository.
     */
    public val issuesEnabled: kotlin.Boolean = builder.issuesEnabled
    /**
     * Name of the GitHub repository to be created in AWS CodeStar.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The GitHub username for the owner of the GitHub repository to be created in AWS CodeStar. If this repository should be owned by a GitHub organization, provide its name.
     */
    public val owner: kotlin.String? = builder.owner
    /**
     * Whether the GitHub repository is to be a private repository.
     */
    public val privateRepository: kotlin.Boolean = builder.privateRepository
    /**
     * The GitHub user's personal access token for the GitHub repository.
     */
    public val token: kotlin.String? = builder.token
    /**
     * The type of GitHub repository to be created in AWS CodeStar. Valid values are User or Organization.
     */
    public val type: kotlin.String? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codestar.model.GitHubCodeDestination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GitHubCodeDestination(")
        append("description=$description,")
        append("issuesEnabled=$issuesEnabled,")
        append("name=$name,")
        append("owner=$owner,")
        append("privateRepository=$privateRepository,")
        append("token=*** Sensitive Data Redacted ***,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (issuesEnabled.hashCode())
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (privateRepository.hashCode())
        result = 31 * result + (token?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GitHubCodeDestination

        if (description != other.description) return false
        if (issuesEnabled != other.issuesEnabled) return false
        if (name != other.name) return false
        if (owner != other.owner) return false
        if (privateRepository != other.privateRepository) return false
        if (token != other.token) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codestar.model.GitHubCodeDestination = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Description for the GitHub repository to be created in AWS CodeStar. This description displays in GitHub after the repository is created.
         */
        public var description: kotlin.String? = null
        /**
         * Whether to enable issues for the GitHub repository.
         */
        public var issuesEnabled: kotlin.Boolean = false
        /**
         * Name of the GitHub repository to be created in AWS CodeStar.
         */
        public var name: kotlin.String? = null
        /**
         * The GitHub username for the owner of the GitHub repository to be created in AWS CodeStar. If this repository should be owned by a GitHub organization, provide its name.
         */
        public var owner: kotlin.String? = null
        /**
         * Whether the GitHub repository is to be a private repository.
         */
        public var privateRepository: kotlin.Boolean = false
        /**
         * The GitHub user's personal access token for the GitHub repository.
         */
        public var token: kotlin.String? = null
        /**
         * The type of GitHub repository to be created in AWS CodeStar. Valid values are User or Organization.
         */
        public var type: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codestar.model.GitHubCodeDestination) : this() {
            this.description = x.description
            this.issuesEnabled = x.issuesEnabled
            this.name = x.name
            this.owner = x.owner
            this.privateRepository = x.privateRepository
            this.token = x.token
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codestar.model.GitHubCodeDestination = GitHubCodeDestination(this)
    }
}
