// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codestar.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codestar.model.CodeStarException
import aws.sdk.kotlin.services.codestar.model.UpdateTeamMemberResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateTeamMemberOperationDeserializer: HttpDeserialize<UpdateTeamMemberResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateTeamMemberResponse {
        if (!response.status.isSuccess()) {
            throwUpdateTeamMemberError(context, response)
        }
        val builder = UpdateTeamMemberResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateTeamMemberOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateTeamMemberError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodeStarException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConcurrentModificationException" -> ConcurrentModificationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidServiceRoleException" -> InvalidServiceRoleExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ProjectConfigurationException" -> ProjectConfigurationExceptionDeserializer().deserialize(context, wrappedResponse)
        "ProjectNotFoundException" -> ProjectNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TeamMemberNotFoundException" -> TeamMemberNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodeStarException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateTeamMemberOperationBody(builder: UpdateTeamMemberResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PROJECTROLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("projectRole"))
    val REMOTEACCESSALLOWED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("remoteAccessAllowed"))
    val USERARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("userArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PROJECTROLE_DESCRIPTOR)
        field(REMOTEACCESSALLOWED_DESCRIPTOR)
        field(USERARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PROJECTROLE_DESCRIPTOR.index -> builder.projectRole = deserializeString()
                REMOTEACCESSALLOWED_DESCRIPTOR.index -> builder.remoteAccessAllowed = deserializeBoolean()
                USERARN_DESCRIPTOR.index -> builder.userArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
