// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codestar.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codestar.model.CodeStarException
import aws.sdk.kotlin.services.codestar.model.DeleteProjectResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteProjectOperationDeserializer: HttpDeserialize<DeleteProjectResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteProjectResponse {
        if (!response.status.isSuccess()) {
            throwDeleteProjectError(context, response)
        }
        val builder = DeleteProjectResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteProjectOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDeleteProjectError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodeStarException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConcurrentModificationException" -> ConcurrentModificationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidServiceRoleException" -> InvalidServiceRoleExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodeStarException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteProjectOperationBody(builder: DeleteProjectResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PROJECTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("projectArn"))
    val STACKID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("stackId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PROJECTARN_DESCRIPTOR)
        field(STACKID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PROJECTARN_DESCRIPTOR.index -> builder.projectArn = deserializeString()
                STACKID_DESCRIPTOR.index -> builder.stackId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
