// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codestar.model



class UpdateTeamMemberRequest private constructor(builder: Builder) {
    /**
     * The ID of the project.
     */
    val projectId: kotlin.String? = builder.projectId
    /**
     * The role assigned to the user in the project. Project roles have different levels of
     * access. For more information, see <a href="http://docs.aws.amazon.com/codestar/latest/userguide/working-with-teams.html">Working with
     * Teams in the AWS CodeStar User Guide.
     */
    val projectRole: kotlin.String? = builder.projectRole
    /**
     * Whether a team member is allowed to remotely access project resources using the SSH
     * public key associated with the user's profile. Even if this is set to True, the user must
     * associate a public key with their profile before the user can access resources.
     */
    val remoteAccessAllowed: kotlin.Boolean = builder.remoteAccessAllowed
    /**
     * The Amazon Resource Name (ARN) of the user for whom you want to change team membership
     * attributes.
     */
    val userArn: kotlin.String? = builder.userArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codestar.model.UpdateTeamMemberRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateTeamMemberRequest(")
        append("projectId=$projectId,")
        append("projectRole=$projectRole,")
        append("remoteAccessAllowed=$remoteAccessAllowed,")
        append("userArn=$userArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = projectId?.hashCode() ?: 0
        result = 31 * result + (projectRole?.hashCode() ?: 0)
        result = 31 * result + (remoteAccessAllowed.hashCode())
        result = 31 * result + (userArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateTeamMemberRequest

        if (projectId != other.projectId) return false
        if (projectRole != other.projectRole) return false
        if (remoteAccessAllowed != other.remoteAccessAllowed) return false
        if (userArn != other.userArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codestar.model.UpdateTeamMemberRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID of the project.
         */
        var projectId: kotlin.String? = null
        /**
         * The role assigned to the user in the project. Project roles have different levels of
         * access. For more information, see <a href="http://docs.aws.amazon.com/codestar/latest/userguide/working-with-teams.html">Working with
         * Teams in the AWS CodeStar User Guide.
         */
        var projectRole: kotlin.String? = null
        /**
         * Whether a team member is allowed to remotely access project resources using the SSH
         * public key associated with the user's profile. Even if this is set to True, the user must
         * associate a public key with their profile before the user can access resources.
         */
        var remoteAccessAllowed: kotlin.Boolean = false
        /**
         * The Amazon Resource Name (ARN) of the user for whom you want to change team membership
         * attributes.
         */
        var userArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codestar.model.UpdateTeamMemberRequest) : this() {
            this.projectId = x.projectId
            this.projectRole = x.projectRole
            this.remoteAccessAllowed = x.remoteAccessAllowed
            this.userArn = x.userArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codestar.model.UpdateTeamMemberRequest = UpdateTeamMemberRequest(this)
    }
}
