// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codestarnotifications

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.codestarnotifications.model.*
import aws.sdk.kotlin.services.codestarnotifications.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "codestar notifications"
const val ServiceApiVersion: String = "2019-10-15"
const val SdkVersion: String = "0.16.5-beta"

internal class DefaultCodestarNotificationsClient(override val config: CodestarNotificationsClient.Config) : CodestarNotificationsClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Creates a notification rule for a resource. The rule specifies the events you want notifications about and the targets (such as SNS topics) where you want to receive them.
     */
    override suspend fun createNotificationRule(input: CreateNotificationRuleRequest): CreateNotificationRuleResponse {
        val op = SdkHttpOperation.build<CreateNotificationRuleRequest, CreateNotificationRuleResponse> {
            serializer = CreateNotificationRuleOperationSerializer()
            deserializer = CreateNotificationRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateNotificationRule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codestar-notifications"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a notification rule for a resource.
     */
    override suspend fun deleteNotificationRule(input: DeleteNotificationRuleRequest): DeleteNotificationRuleResponse {
        val op = SdkHttpOperation.build<DeleteNotificationRuleRequest, DeleteNotificationRuleResponse> {
            serializer = DeleteNotificationRuleOperationSerializer()
            deserializer = DeleteNotificationRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteNotificationRule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codestar-notifications"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a specified target for notifications.
     */
    override suspend fun deleteTarget(input: DeleteTargetRequest): DeleteTargetResponse {
        val op = SdkHttpOperation.build<DeleteTargetRequest, DeleteTargetResponse> {
            serializer = DeleteTargetOperationSerializer()
            deserializer = DeleteTargetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTarget"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codestar-notifications"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a specified notification rule.
     */
    override suspend fun describeNotificationRule(input: DescribeNotificationRuleRequest): DescribeNotificationRuleResponse {
        val op = SdkHttpOperation.build<DescribeNotificationRuleRequest, DescribeNotificationRuleResponse> {
            serializer = DescribeNotificationRuleOperationSerializer()
            deserializer = DescribeNotificationRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeNotificationRule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codestar-notifications"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the event types available for configuring notifications.
     */
    override suspend fun listEventTypes(input: ListEventTypesRequest): ListEventTypesResponse {
        val op = SdkHttpOperation.build<ListEventTypesRequest, ListEventTypesResponse> {
            serializer = ListEventTypesOperationSerializer()
            deserializer = ListEventTypesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListEventTypes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codestar-notifications"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of the notification rules for an AWS account.
     */
    override suspend fun listNotificationRules(input: ListNotificationRulesRequest): ListNotificationRulesResponse {
        val op = SdkHttpOperation.build<ListNotificationRulesRequest, ListNotificationRulesResponse> {
            serializer = ListNotificationRulesOperationSerializer()
            deserializer = ListNotificationRulesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListNotificationRules"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codestar-notifications"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of the tags associated with a notification rule.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codestar-notifications"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of the notification rule targets for an AWS account.
     */
    override suspend fun listTargets(input: ListTargetsRequest): ListTargetsResponse {
        val op = SdkHttpOperation.build<ListTargetsRequest, ListTargetsResponse> {
            serializer = ListTargetsOperationSerializer()
            deserializer = ListTargetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTargets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codestar-notifications"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an association between a notification rule and an SNS topic so that the associated target can receive notifications when the events described in the rule are triggered.
     */
    override suspend fun subscribe(input: SubscribeRequest): SubscribeResponse {
        val op = SdkHttpOperation.build<SubscribeRequest, SubscribeResponse> {
            serializer = SubscribeOperationSerializer()
            deserializer = SubscribeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "Subscribe"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codestar-notifications"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates a set of provided tags with a notification rule.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codestar-notifications"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes an association between a notification rule and an Amazon SNS topic so that subscribers to that topic stop receiving notifications when the events described in the rule are triggered.
     */
    override suspend fun unsubscribe(input: UnsubscribeRequest): UnsubscribeResponse {
        val op = SdkHttpOperation.build<UnsubscribeRequest, UnsubscribeResponse> {
            serializer = UnsubscribeOperationSerializer()
            deserializer = UnsubscribeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "Unsubscribe"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codestar-notifications"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the association between one or more provided tags and a notification rule.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codestar-notifications"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a notification rule for a resource. You can change the events that trigger the notification rule, the status of the rule, and the targets that receive the notifications.
     *
     * To add or remove tags for a notification rule, you must use TagResource and UntagResource.
     */
    override suspend fun updateNotificationRule(input: UpdateNotificationRuleRequest): UpdateNotificationRuleResponse {
        val op = SdkHttpOperation.build<UpdateNotificationRuleRequest, UpdateNotificationRuleResponse> {
            serializer = UpdateNotificationRuleOperationSerializer()
            deserializer = UpdateNotificationRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateNotificationRule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "codestar-notifications"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "codestar-notifications")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
