// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codestarnotifications.model



class CreateNotificationRuleRequest private constructor(builder: Builder) {
    /**
     * A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request with the same parameters is received and a token is included, the request returns information about the initial request that used that token.
     *
     * The AWS SDKs prepopulate client request tokens. If you are using an AWS SDK, an idempotency token is created for you.
     */
    val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The level of detail to include in the notifications for this resource. BASIC will include only the contents of the event as it would appear in AWS CloudWatch. FULL will include any supplemental information provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.
     */
    val detailType: aws.sdk.kotlin.services.codestarnotifications.model.DetailType? = builder.detailType
    /**
     * A list of event types associated with this notification rule. For a list of allowed events, see EventTypeSummary.
     */
    val eventTypeIds: List<String>? = builder.eventTypeIds
    /**
     * The name for the notification rule. Notifictaion rule names must be unique in your AWS account.
     */
    val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the resource to associate with the notification rule. Supported resources include pipelines in AWS CodePipeline, repositories in AWS CodeCommit, and build projects in AWS CodeBuild.
     */
    val resource: kotlin.String? = builder.resource
    /**
     * The status of the notification rule. The default value is ENABLED. If the status is set to DISABLED, notifications aren't sent for the notification rule.
     */
    val status: aws.sdk.kotlin.services.codestarnotifications.model.NotificationRuleStatus? = builder.status
    /**
     * A list of tags to apply to this notification rule. Key names cannot start with "aws".
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * A list of Amazon Resource Names (ARNs) of SNS topics to associate with the notification rule.
     */
    val targets: List<Target>? = builder.targets

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codestarnotifications.model.CreateNotificationRuleRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateNotificationRuleRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("detailType=$detailType,")
        append("eventTypeIds=$eventTypeIds,")
        append("name=*** Sensitive Data Redacted ***,")
        append("resource=$resource,")
        append("status=$status,")
        append("tags=$tags,")
        append("targets=$targets)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (detailType?.hashCode() ?: 0)
        result = 31 * result + (eventTypeIds?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resource?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateNotificationRuleRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (detailType != other.detailType) return false
        if (eventTypeIds != other.eventTypeIds) return false
        if (name != other.name) return false
        if (resource != other.resource) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (targets != other.targets) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codestarnotifications.model.CreateNotificationRuleRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request with the same parameters is received and a token is included, the request returns information about the initial request that used that token.
         *
         * The AWS SDKs prepopulate client request tokens. If you are using an AWS SDK, an idempotency token is created for you.
         */
        var clientRequestToken: kotlin.String? = null
        /**
         * The level of detail to include in the notifications for this resource. BASIC will include only the contents of the event as it would appear in AWS CloudWatch. FULL will include any supplemental information provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.
         */
        var detailType: aws.sdk.kotlin.services.codestarnotifications.model.DetailType? = null
        /**
         * A list of event types associated with this notification rule. For a list of allowed events, see EventTypeSummary.
         */
        var eventTypeIds: List<String>? = null
        /**
         * The name for the notification rule. Notifictaion rule names must be unique in your AWS account.
         */
        var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the resource to associate with the notification rule. Supported resources include pipelines in AWS CodePipeline, repositories in AWS CodeCommit, and build projects in AWS CodeBuild.
         */
        var resource: kotlin.String? = null
        /**
         * The status of the notification rule. The default value is ENABLED. If the status is set to DISABLED, notifications aren't sent for the notification rule.
         */
        var status: aws.sdk.kotlin.services.codestarnotifications.model.NotificationRuleStatus? = null
        /**
         * A list of tags to apply to this notification rule. Key names cannot start with "aws".
         */
        var tags: Map<String, String>? = null
        /**
         * A list of Amazon Resource Names (ARNs) of SNS topics to associate with the notification rule.
         */
        var targets: List<Target>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codestarnotifications.model.CreateNotificationRuleRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.detailType = x.detailType
            this.eventTypeIds = x.eventTypeIds
            this.name = x.name
            this.resource = x.resource
            this.status = x.status
            this.tags = x.tags
            this.targets = x.targets
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codestarnotifications.model.CreateNotificationRuleRequest = CreateNotificationRuleRequest(this)
    }
}
