// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codestarnotifications.model

import aws.smithy.kotlin.runtime.time.Instant

class DescribeNotificationRuleResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the notification rule.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The name or email alias of the person who created the notification rule.
     */
    val createdBy: kotlin.String? = builder.createdBy
    /**
     * The date and time the notification rule was created, in timestamp format.
     */
    val createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTimestamp
    /**
     * The level of detail included in the notifications for this resource. BASIC will include only the contents of the event as it would appear in AWS CloudWatch. FULL will include any supplemental information provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.
     */
    val detailType: aws.sdk.kotlin.services.codestarnotifications.model.DetailType? = builder.detailType
    /**
     * A list of the event types associated with the notification rule.
     */
    val eventTypes: List<EventTypeSummary>? = builder.eventTypes
    /**
     * The date and time the notification rule was most recently updated, in timestamp format.
     */
    val lastModifiedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTimestamp
    /**
     * The name of the notification rule.
     */
    val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the resource associated with the notification rule.
     */
    val resource: kotlin.String? = builder.resource
    /**
     * The status of the notification rule. Valid statuses are on (sending notifications) or off (not sending notifications).
     */
    val status: aws.sdk.kotlin.services.codestarnotifications.model.NotificationRuleStatus? = builder.status
    /**
     * The tags associated with the notification rule.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * A list of the SNS topics associated with the notification rule.
     */
    val targets: List<TargetSummary>? = builder.targets

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codestarnotifications.model.DescribeNotificationRuleResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeNotificationRuleResponse(")
        append("arn=$arn,")
        append("createdBy=$createdBy,")
        append("createdTimestamp=$createdTimestamp,")
        append("detailType=$detailType,")
        append("eventTypes=$eventTypes,")
        append("lastModifiedTimestamp=$lastModifiedTimestamp,")
        append("name=*** Sensitive Data Redacted ***,")
        append("resource=$resource,")
        append("status=$status,")
        append("tags=$tags,")
        append("targets=$targets)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (createdTimestamp?.hashCode() ?: 0)
        result = 31 * result + (detailType?.hashCode() ?: 0)
        result = 31 * result + (eventTypes?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resource?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeNotificationRuleResponse

        if (arn != other.arn) return false
        if (createdBy != other.createdBy) return false
        if (createdTimestamp != other.createdTimestamp) return false
        if (detailType != other.detailType) return false
        if (eventTypes != other.eventTypes) return false
        if (lastModifiedTimestamp != other.lastModifiedTimestamp) return false
        if (name != other.name) return false
        if (resource != other.resource) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (targets != other.targets) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codestarnotifications.model.DescribeNotificationRuleResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the notification rule.
         */
        var arn: kotlin.String? = null
        /**
         * The name or email alias of the person who created the notification rule.
         */
        var createdBy: kotlin.String? = null
        /**
         * The date and time the notification rule was created, in timestamp format.
         */
        var createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The level of detail included in the notifications for this resource. BASIC will include only the contents of the event as it would appear in AWS CloudWatch. FULL will include any supplemental information provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.
         */
        var detailType: aws.sdk.kotlin.services.codestarnotifications.model.DetailType? = null
        /**
         * A list of the event types associated with the notification rule.
         */
        var eventTypes: List<EventTypeSummary>? = null
        /**
         * The date and time the notification rule was most recently updated, in timestamp format.
         */
        var lastModifiedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the notification rule.
         */
        var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the resource associated with the notification rule.
         */
        var resource: kotlin.String? = null
        /**
         * The status of the notification rule. Valid statuses are on (sending notifications) or off (not sending notifications).
         */
        var status: aws.sdk.kotlin.services.codestarnotifications.model.NotificationRuleStatus? = null
        /**
         * The tags associated with the notification rule.
         */
        var tags: Map<String, String>? = null
        /**
         * A list of the SNS topics associated with the notification rule.
         */
        var targets: List<TargetSummary>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codestarnotifications.model.DescribeNotificationRuleResponse) : this() {
            this.arn = x.arn
            this.createdBy = x.createdBy
            this.createdTimestamp = x.createdTimestamp
            this.detailType = x.detailType
            this.eventTypes = x.eventTypes
            this.lastModifiedTimestamp = x.lastModifiedTimestamp
            this.name = x.name
            this.resource = x.resource
            this.status = x.status
            this.tags = x.tags
            this.targets = x.targets
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codestarnotifications.model.DescribeNotificationRuleResponse = DescribeNotificationRuleResponse(this)
    }
}
