// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codestarnotifications

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.codestarnotifications.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.codestarnotifications.model.*
import aws.sdk.kotlin.services.codestarnotifications.model.CreateNotificationRuleRequest
import aws.sdk.kotlin.services.codestarnotifications.model.CreateNotificationRuleResponse
import aws.sdk.kotlin.services.codestarnotifications.model.DeleteNotificationRuleRequest
import aws.sdk.kotlin.services.codestarnotifications.model.DeleteNotificationRuleResponse
import aws.sdk.kotlin.services.codestarnotifications.model.DeleteTargetRequest
import aws.sdk.kotlin.services.codestarnotifications.model.DeleteTargetResponse
import aws.sdk.kotlin.services.codestarnotifications.model.DescribeNotificationRuleRequest
import aws.sdk.kotlin.services.codestarnotifications.model.DescribeNotificationRuleResponse
import aws.sdk.kotlin.services.codestarnotifications.model.ListEventTypesRequest
import aws.sdk.kotlin.services.codestarnotifications.model.ListEventTypesResponse
import aws.sdk.kotlin.services.codestarnotifications.model.ListNotificationRulesRequest
import aws.sdk.kotlin.services.codestarnotifications.model.ListNotificationRulesResponse
import aws.sdk.kotlin.services.codestarnotifications.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.codestarnotifications.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.codestarnotifications.model.ListTargetsRequest
import aws.sdk.kotlin.services.codestarnotifications.model.ListTargetsResponse
import aws.sdk.kotlin.services.codestarnotifications.model.SubscribeRequest
import aws.sdk.kotlin.services.codestarnotifications.model.SubscribeResponse
import aws.sdk.kotlin.services.codestarnotifications.model.TagResourceRequest
import aws.sdk.kotlin.services.codestarnotifications.model.TagResourceResponse
import aws.sdk.kotlin.services.codestarnotifications.model.UnsubscribeRequest
import aws.sdk.kotlin.services.codestarnotifications.model.UnsubscribeResponse
import aws.sdk.kotlin.services.codestarnotifications.model.UntagResourceRequest
import aws.sdk.kotlin.services.codestarnotifications.model.UntagResourceResponse
import aws.sdk.kotlin.services.codestarnotifications.model.UpdateNotificationRuleRequest
import aws.sdk.kotlin.services.codestarnotifications.model.UpdateNotificationRuleResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * This AWS CodeStar Notifications API Reference provides descriptions and usage examples of the operations and data types for the AWS CodeStar Notifications API. You can use the AWS CodeStar Notifications API to work with the following objects:
 *
 * Notification rules, by calling the following:
 * + CreateNotificationRule, which creates a notification rule for a resource in your account.
 * + DeleteNotificationRule, which deletes a notification rule.
 * + DescribeNotificationRule, which provides information about a notification rule.
 * + ListNotificationRules, which lists the notification rules associated with your account.
 * + UpdateNotificationRule, which changes the name, events, or targets associated with a notification rule.
 * + Subscribe, which subscribes a target to a notification rule.
 * + Unsubscribe, which removes a target from a notification rule.
 *
 * Targets, by calling the following:
 * + DeleteTarget, which removes a notification rule target (SNS topic) from a notification rule.
 * + ListTargets, which lists the targets associated with a notification rule.
 *
 * Events, by calling the following:
 * + ListEventTypes, which lists the event types you can include in a notification rule.
 *
 * Tags, by calling the following:
 * + ListTagsForResource, which lists the tags already associated with a notification rule in your account.
 * + TagResource, which associates a tag you provide with a notification rule in your account.
 * + UntagResource, which removes a tag from a notification rule in your account.
 *
 *  For information about how to use AWS CodeStar Notifications, see link in the CodeStarNotifications User Guide.
 */
public interface CodestarNotificationsClient : SdkClient {

    override val serviceName: String
        get() = "codestar notifications"
    /**
     * CodestarNotificationsClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): CodestarNotificationsClient {
            val config = Config.Builder().apply(block).build()
            return DefaultCodestarNotificationsClient(config)
        }

        public operator fun invoke(config: Config): CodestarNotificationsClient = DefaultCodestarNotificationsClient(config)

        /**
         * Construct a [CodestarNotificationsClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): CodestarNotificationsClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultCodestarNotificationsClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a notification rule for a resource. The rule specifies the events you want notifications about and the targets (such as SNS topics) where you want to receive them.
     */
    public suspend fun createNotificationRule(input: CreateNotificationRuleRequest): CreateNotificationRuleResponse

    /**
     * Deletes a notification rule for a resource.
     */
    public suspend fun deleteNotificationRule(input: DeleteNotificationRuleRequest): DeleteNotificationRuleResponse

    /**
     * Deletes a specified target for notifications.
     */
    public suspend fun deleteTarget(input: DeleteTargetRequest): DeleteTargetResponse

    /**
     * Returns information about a specified notification rule.
     */
    public suspend fun describeNotificationRule(input: DescribeNotificationRuleRequest): DescribeNotificationRuleResponse

    /**
     * Returns information about the event types available for configuring notifications.
     */
    public suspend fun listEventTypes(input: ListEventTypesRequest = ListEventTypesRequest {}): ListEventTypesResponse

    /**
     * Returns a list of the notification rules for an AWS account.
     */
    public suspend fun listNotificationRules(input: ListNotificationRulesRequest = ListNotificationRulesRequest {}): ListNotificationRulesResponse

    /**
     * Returns a list of the tags associated with a notification rule.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns a list of the notification rule targets for an AWS account.
     */
    public suspend fun listTargets(input: ListTargetsRequest = ListTargetsRequest {}): ListTargetsResponse

    /**
     * Creates an association between a notification rule and an SNS topic so that the associated target can receive notifications when the events described in the rule are triggered.
     */
    public suspend fun subscribe(input: SubscribeRequest): SubscribeResponse

    /**
     * Associates a set of provided tags with a notification rule.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes an association between a notification rule and an Amazon SNS topic so that subscribers to that topic stop receiving notifications when the events described in the rule are triggered.
     */
    public suspend fun unsubscribe(input: UnsubscribeRequest): UnsubscribeResponse

    /**
     * Removes the association between one or more provided tags and a notification rule.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a notification rule for a resource. You can change the events that trigger the notification rule, the status of the rule, and the targets that receive the notifications.
     *
     * To add or remove tags for a notification rule, you must use TagResource and UntagResource.
     */
    public suspend fun updateNotificationRule(input: UpdateNotificationRuleRequest): UpdateNotificationRuleResponse
}

/**
 * Creates a notification rule for a resource. The rule specifies the events you want notifications about and the targets (such as SNS topics) where you want to receive them.
 */
public suspend inline fun CodestarNotificationsClient.createNotificationRule(crossinline block: CreateNotificationRuleRequest.Builder.() -> Unit): CreateNotificationRuleResponse = createNotificationRule(CreateNotificationRuleRequest.Builder().apply(block).build())

/**
 * Deletes a notification rule for a resource.
 */
public suspend inline fun CodestarNotificationsClient.deleteNotificationRule(crossinline block: DeleteNotificationRuleRequest.Builder.() -> Unit): DeleteNotificationRuleResponse = deleteNotificationRule(DeleteNotificationRuleRequest.Builder().apply(block).build())

/**
 * Deletes a specified target for notifications.
 */
public suspend inline fun CodestarNotificationsClient.deleteTarget(crossinline block: DeleteTargetRequest.Builder.() -> Unit): DeleteTargetResponse = deleteTarget(DeleteTargetRequest.Builder().apply(block).build())

/**
 * Returns information about a specified notification rule.
 */
public suspend inline fun CodestarNotificationsClient.describeNotificationRule(crossinline block: DescribeNotificationRuleRequest.Builder.() -> Unit): DescribeNotificationRuleResponse = describeNotificationRule(DescribeNotificationRuleRequest.Builder().apply(block).build())

/**
 * Returns information about the event types available for configuring notifications.
 */
public suspend inline fun CodestarNotificationsClient.listEventTypes(crossinline block: ListEventTypesRequest.Builder.() -> Unit): ListEventTypesResponse = listEventTypes(ListEventTypesRequest.Builder().apply(block).build())

/**
 * Returns a list of the notification rules for an AWS account.
 */
public suspend inline fun CodestarNotificationsClient.listNotificationRules(crossinline block: ListNotificationRulesRequest.Builder.() -> Unit): ListNotificationRulesResponse = listNotificationRules(ListNotificationRulesRequest.Builder().apply(block).build())

/**
 * Returns a list of the tags associated with a notification rule.
 */
public suspend inline fun CodestarNotificationsClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Returns a list of the notification rule targets for an AWS account.
 */
public suspend inline fun CodestarNotificationsClient.listTargets(crossinline block: ListTargetsRequest.Builder.() -> Unit): ListTargetsResponse = listTargets(ListTargetsRequest.Builder().apply(block).build())

/**
 * Creates an association between a notification rule and an SNS topic so that the associated target can receive notifications when the events described in the rule are triggered.
 */
public suspend inline fun CodestarNotificationsClient.subscribe(crossinline block: SubscribeRequest.Builder.() -> Unit): SubscribeResponse = subscribe(SubscribeRequest.Builder().apply(block).build())

/**
 * Associates a set of provided tags with a notification rule.
 */
public suspend inline fun CodestarNotificationsClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes an association between a notification rule and an Amazon SNS topic so that subscribers to that topic stop receiving notifications when the events described in the rule are triggered.
 */
public suspend inline fun CodestarNotificationsClient.unsubscribe(crossinline block: UnsubscribeRequest.Builder.() -> Unit): UnsubscribeResponse = unsubscribe(UnsubscribeRequest.Builder().apply(block).build())

/**
 * Removes the association between one or more provided tags and a notification rule.
 */
public suspend inline fun CodestarNotificationsClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a notification rule for a resource. You can change the events that trigger the notification rule, the status of the rule, and the targets that receive the notifications.
 *
 * To add or remove tags for a notification rule, you must use TagResource and UntagResource.
 */
public suspend inline fun CodestarNotificationsClient.updateNotificationRule(crossinline block: UpdateNotificationRuleRequest.Builder.() -> Unit): UpdateNotificationRuleResponse = updateNotificationRule(UpdateNotificationRuleRequest.Builder().apply(block).build())
