// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codestarnotifications

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.codestarnotifications.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.codestarnotifications.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.delay.StandardRetryTokenBucketOptions

/**
 * This AWS CodeStar Notifications API Reference provides descriptions and usage examples of the
 * operations and data types for the AWS CodeStar Notifications API. You can use the AWS CodeStar Notifications API
 * to work with the following objects:
 *
 * Notification rules, by calling the following:
 *
 *
 *
 * CreateNotificationRule, which creates a notification rule for a
 * resource in your account.
 *
 *
 * DeleteNotificationRule, which deletes a notification rule.
 *
 *
 * DescribeNotificationRule, which provides information about a notification rule.
 *
 *
 * ListNotificationRules, which lists the notification rules associated with
 * your account.
 *
 *
 * UpdateNotificationRule, which changes the name, events, or targets associated with a
 * notification rule.
 *
 *
 * Subscribe, which subscribes a target to a notification rule.
 *
 *
 * Unsubscribe, which removes a target from a notification rule.
 *
 *
 *
 * Targets, by calling the following:
 *
 *
 *
 * DeleteTarget, which removes a notification rule target (SNS topic) from a
 * notification rule.
 *
 *
 * ListTargets, which lists the targets associated with a
 * notification rule.
 *
 *
 *
 * Events, by calling the following:
 *
 *
 *
 * ListEventTypes, which lists the event types you can include in
 * a notification rule.
 *
 *
 * Tags, by calling the following:
 *
 *
 *
 * ListTagsForResource, which lists the tags already associated
 * with a notification rule in your account.
 *
 *
 * TagResource, which associates a tag you provide with a
 * notification rule in your account.
 *
 *
 * UntagResource, which removes a tag from a notification rule in
 * your account.
 *
 *
 *
 *
 *
 * For information about how to use AWS CodeStar Notifications, see link in the CodeStarNotifications User Guide.
 */
interface CodestarNotificationsClient : SdkClient {

    override val serviceName: String
        get() = "codestar notifications"
    /**
     * CodestarNotificationsClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): CodestarNotificationsClient {
            val config = Config.Builder().apply(block).build()
            return DefaultCodestarNotificationsClient(config)
        }

        operator fun invoke(config: Config): CodestarNotificationsClient = DefaultCodestarNotificationsClient(config)

        /**
         * Construct a [CodestarNotificationsClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): CodestarNotificationsClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultCodestarNotificationsClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a notification rule for a resource. The rule specifies the events you want
     * notifications about and the targets (such as SNS topics) where you want to receive
     * them.
     */
    suspend fun createNotificationRule(input: CreateNotificationRuleRequest): CreateNotificationRuleResponse

    /**
     * Creates a notification rule for a resource. The rule specifies the events you want
     * notifications about and the targets (such as SNS topics) where you want to receive
     * them.
     */
    suspend fun createNotificationRule(block: CreateNotificationRuleRequest.Builder.() -> Unit) = createNotificationRule(CreateNotificationRuleRequest.Builder().apply(block).build())

    /**
     * Deletes a notification rule for a resource.
     */
    suspend fun deleteNotificationRule(input: DeleteNotificationRuleRequest): DeleteNotificationRuleResponse

    /**
     * Deletes a notification rule for a resource.
     */
    suspend fun deleteNotificationRule(block: DeleteNotificationRuleRequest.Builder.() -> Unit) = deleteNotificationRule(DeleteNotificationRuleRequest.Builder().apply(block).build())

    /**
     * Deletes a specified target for notifications.
     */
    suspend fun deleteTarget(input: DeleteTargetRequest): DeleteTargetResponse

    /**
     * Deletes a specified target for notifications.
     */
    suspend fun deleteTarget(block: DeleteTargetRequest.Builder.() -> Unit) = deleteTarget(DeleteTargetRequest.Builder().apply(block).build())

    /**
     * Returns information about a specified notification rule.
     */
    suspend fun describeNotificationRule(input: DescribeNotificationRuleRequest): DescribeNotificationRuleResponse

    /**
     * Returns information about a specified notification rule.
     */
    suspend fun describeNotificationRule(block: DescribeNotificationRuleRequest.Builder.() -> Unit) = describeNotificationRule(DescribeNotificationRuleRequest.Builder().apply(block).build())

    /**
     * Returns information about the event types available for configuring notifications.
     */
    suspend fun listEventTypes(input: ListEventTypesRequest): ListEventTypesResponse

    /**
     * Returns information about the event types available for configuring notifications.
     */
    suspend fun listEventTypes(block: ListEventTypesRequest.Builder.() -> Unit) = listEventTypes(ListEventTypesRequest.Builder().apply(block).build())

    /**
     * Returns a list of the notification rules for an AWS account.
     */
    suspend fun listNotificationRules(input: ListNotificationRulesRequest): ListNotificationRulesResponse

    /**
     * Returns a list of the notification rules for an AWS account.
     */
    suspend fun listNotificationRules(block: ListNotificationRulesRequest.Builder.() -> Unit) = listNotificationRules(ListNotificationRulesRequest.Builder().apply(block).build())

    /**
     * Returns a list of the tags associated with a notification rule.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns a list of the tags associated with a notification rule.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Returns a list of the notification rule targets for an AWS account.
     */
    suspend fun listTargets(input: ListTargetsRequest): ListTargetsResponse

    /**
     * Returns a list of the notification rule targets for an AWS account.
     */
    suspend fun listTargets(block: ListTargetsRequest.Builder.() -> Unit) = listTargets(ListTargetsRequest.Builder().apply(block).build())

    /**
     * Creates an association between a notification rule and an SNS topic so that the
     * associated target can receive notifications when the events described in the rule are
     * triggered.
     */
    suspend fun subscribe(input: SubscribeRequest): SubscribeResponse

    /**
     * Creates an association between a notification rule and an SNS topic so that the
     * associated target can receive notifications when the events described in the rule are
     * triggered.
     */
    suspend fun subscribe(block: SubscribeRequest.Builder.() -> Unit) = subscribe(SubscribeRequest.Builder().apply(block).build())

    /**
     * Associates a set of provided tags with a notification rule.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Associates a set of provided tags with a notification rule.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Removes an association between a notification rule and an Amazon SNS topic so that
     * subscribers to that topic stop receiving notifications when the events described in the
     * rule are triggered.
     */
    suspend fun unsubscribe(input: UnsubscribeRequest): UnsubscribeResponse

    /**
     * Removes an association between a notification rule and an Amazon SNS topic so that
     * subscribers to that topic stop receiving notifications when the events described in the
     * rule are triggered.
     */
    suspend fun unsubscribe(block: UnsubscribeRequest.Builder.() -> Unit) = unsubscribe(UnsubscribeRequest.Builder().apply(block).build())

    /**
     * Removes the association between one or more provided tags and a notification
     * rule.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes the association between one or more provided tags and a notification
     * rule.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates a notification rule for a resource. You can change the events that trigger the
     * notification rule, the status of the rule, and the targets that receive the
     * notifications.
     *
     * To add or remove tags for a notification rule, you must use TagResource and UntagResource.
     */
    suspend fun updateNotificationRule(input: UpdateNotificationRuleRequest): UpdateNotificationRuleResponse

    /**
     * Updates a notification rule for a resource. You can change the events that trigger the
     * notification rule, the status of the rule, and the targets that receive the
     * notifications.
     *
     * To add or remove tags for a notification rule, you must use TagResource and UntagResource.
     */
    suspend fun updateNotificationRule(block: UpdateNotificationRuleRequest.Builder.() -> Unit) = updateNotificationRule(UpdateNotificationRuleRequest.Builder().apply(block).build())
}
